(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    197507,       5645]*)
(*NotebookOutlinePosition[    199261,       5698]*)
(*  CellTagsIndexPosition[    199157,       5691]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Coordenadas curvil\[IAcute]neas", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(Off[ParametricPlot3D::ppcom]\), "\n", 
    \(Off[General::spell1]\), "\[IndentingNewLine]", 
    \(Off[General::spell]\)}], "Input",
  InitializationCell->True],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(\(\(vector2D[x_: {0, 0}, y_]\)\(:=\)\(Arrow[x, x + y]\)\(\ \)\( (*\ 
        traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x . \ 
              Por\ defecto\ x = {0, 0}*) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \n
    \(\(normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]]; \  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \n
    normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]]\)\(\n\)
    \)\)\( (*\ 
      un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\n
    vector3D[x_List: {0, 0, 0}, y_List, color_:  RGBColor[0. , 0. , 0. ], 
        grosor_:  0.007] := arrow3D[x, x + y, color, grosor]\)\(\ \)\( (*\ 
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(coordpolares := 
        Show[Graphics[{Line[{{\(- .75\), 0}, {2, 0}}], 
              Line[{{0, \(- .3\)}, {0, 2}}], Text["\<Y\>", {0.1, 1.9}], 
              Text["\<X\>", {2,  .1}], {Blue, Text["\<P\>", {1.16, 1}]}, 
              Circle[{0, 0},  .4, {0, \[Pi]/4}], 
              Arrow[ .4 {Cos[\[Pi]/4 -  .07], 
                    Sin[\[Pi]/4 -  .1]},  .4 {\@2/2, \@2/2}, 
                HeadLength ->  .04], {Red, 
                Arrow[{1, 1}, {1, 1} +  .4 {1, 1}, HeadLength ->  .04], 
                Arrow[{1, 1}, {1, 1} +  .4 {\(-1\), 1}, 
                  HeadLength ->  .04]}, {PointSize[ .035], Hue[ .6], 
                Point[{1, 1}], Hue[0], Point[{0, 1}], Point[{1, 0}], 
                Text["\<x=\[Rho]cos\[Theta]\>", {1, \(- .15\)}], 
                Text["\<y=\[Rho]sen\[Theta]\>", {\(- .45\), 1.0}], 
                Text["\<\[Theta]\>", { .5,  .2}], 
                Text[\*"\"\<\[Rho]=\!\(\@\(x\^2 + y\^2\)\)\>\"", {1.15,  \
.6}]}, Text[\*"\"\<\!\(e\_\[Rho]\)\>\"", {1.5, 1.5}], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", { .5, 
                  1.5}], {Line[{{0, 0}, {1, 1}}], Dashing[{ .02,  .02}], 
                Line[{{0, 1}, {1, 1}, {1, 0}}]}}], 
          Background \[Rule] RGBColor[1, 1, 0.75], 
          AspectRatio \[Rule] Automatic, 
          TextStyle \[Rule] {FontSize \[Rule] 12, FontWeight -> "\<Bold\>"}, 
          ImageSize \[Rule] {563, 234}];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(coordcilindricas := 
        Show[Graphics[{Line[{{0, 6}, {0, 0}, {2, 4}, {0, 0}, {6, 0}, {0, 
                    0}, {\(-4\), \(-4\)}}], {Dashing[{ .012,  .012}], 
                Line[{{0, 5.5}, {2, 4}, {2, \(-1.5\)}, {0, 
                      0}}]}, {Dashing[{ .012,  .012}], 
                Line[{{2, \(-1.5\)}, {3.5, 0}}]}, {Dashing[{ .012,  .012}], 
                Line[{{2, \(-1.5\)}, {\(-1.5\), \(-1.5\)}}]}, 
              Circle[{0, 0},  .6, {\(-3\) \[Pi]/4, ArcTan[\(- .75\)]}], {Hue[
                  0], PointSize[ .02], \ Point[{0.01, 5.5}], 
                Text["\<z\>", {\(- .3\), 5.5}], 
                Text[\*"\"\<\[Rho]=\!\(\@\(x\^2 + y\^2\)\)\>\"", {3, \
\(-1.7\)}], Text["\<x=\[Rho]cos\[Theta]\>", {\(-1.7\), \(-1.8\)}], 
                Text["\<y=\[Rho]sen\[Theta]\>", {3.7,  .35}], 
                Text["\<\[Theta]\>", {0, \(-1\)}]}, {Hue[0], 
                PointSize[ .02], \ Point[{3.5, 0}]}, {Hue[0], 
                PointSize[ .02], \ Point[{\(-1.5\), \(-1.5\)}]}, {Hue[0.6], 
                PointSize[ .02], \ Point[{2, 4}]}, {Red, 
                Arrow[{2, 4}, {2, 4} +  .4 {0, 4}, HeadLength ->  .04], 
                Arrow[{2, 4}, {2, 4} +  .6 {2, \(-1.5\)}, 
                  HeadLength ->  .04], \n\t\t\t\tArrow[{2, 4}, {2, 4} + 
                    1.2 {1.3,  .5}, HeadLength ->  .04]}, {Blue, 
                Text["\<P\>", {2.55, 3.9}]}, 
              Text["\<X\>", {\(-3.4\), \(-3.9\)}], 
              Text["\<Z\>", {0.3, 5.95}], Text["\<Y\>", {5.95, 0.25}], 
              Text[\*"\"\<\!\(e\_z\)\>\"", {2, 6}], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", {3.9, 4.8}], 
              Text[\*"\"\<\!\(e\_\[Rho]\)\>\"", {3.4, 2.9}]}], 
          AspectRatio \[Rule] Automatic, 
          Background \[Rule] RGBColor[1, 1, 0.75], 
          TextStyle \[Rule] {FontSize \[Rule] 12, 
              FontWeight -> "\<Bold\>"}];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(coordesfericas := 
        Show[Graphics[{Line[{{0, 6}, {0, 0}, {2, 4}, {0, 0}, {6, 0}, {0, 
                    0}, {\(-4\), \(-4\)}}], {Dashing[{ .012,  .012}], 
                Line[{{0, 5.5}, {2, 4}, {2, \(-1.5\)}, {0, 
                      0}}]}, {Dashing[{ .012,  .012}], 
                Line[{{2, \(-1.5\)}, {3.5, 0}}]}, {Dashing[{ .012,  .012}], 
                Line[{{2, \(-1.5\)}, {\(-1.5\), \(-1.5\)}}]}, 
              Circle[{0, 0}, 2, {ArcTan[2], \[Pi]/2}], 
              Circle[{0, 0},  .6, {\(-3\) \[Pi]/4, ArcTan[\(- .75\)]}], {Hue[
                  0], PointSize[ .02], \ Point[{0.01, 5.5}], 
                Text["\<z=rcos\[Theta]\>", {1, 5.6}], 
                Text[\*"\"\<r=\!\(\@\(x\^2 + y\^2 + z\^2\)\)\>\"", {2.9, 
                    2.12}], Text["\<rsen\[Theta]\>", {2.2, \(-1.8\)}], 
                Text["\<x=rsen\[Theta]cos\[Phi]\>", {\(-1.7\), \(-1.8\)}], 
                Text["\<y=rsen\[Theta]sen\[Phi]\>", {3.7,  .35}], 
                Text["\<\[Theta]\>", { .485, 2.47}], 
                Text["\<\[Phi]\>", {0, \(-1\)}]}, {Hue[0], PointSize[ .02], \ 
                Point[{3.5, 0}]}, {Hue[0], PointSize[ .02], \ 
                Point[{\(-1.5\), \(-1.5\)}]}, {Hue[0.6], PointSize[ .02], \ 
                Point[{2, 4}]}, {Red, 
                Arrow[{2, 4}, {2, 4} +  .4 {2, 4}, HeadLength ->  .04], 
                Arrow[{2, 4}, {2, 4} +  .6 {2, \(-1.5\)}, 
                  HeadLength ->  .04], \n\t\t\t\tArrow[{2, 4}, {2, 4} + 
                    1.2 {1.3,  .5}, HeadLength ->  .04]}, {Blue, 
                Text["\<P\>", {2.55, 3.9}]}, 
              Text["\<X\>", {\(-3.4\), \(-3.9\)}], 
              Text["\<Z\>", {0.3, 5.95}], Text["\<Y\>", {5.95, 0.25}], 
              Text[\*"\"\<\!\(e\_r\)\>\"", {2.9, 5.8}], 
              Text[\*"\"\<\!\(e\_\[Phi]\)\>\"", {3.9, 4.8}], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", {3.4, 2.9}]}], 
          AspectRatio \[Rule] Automatic, 
          Background \[Rule] RGBColor[1, 1, 0.75], 
          TextStyle \[Rule] {FontSize \[Rule] 12, 
              FontWeight -> "\<Bold\>"}];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(Unprotect[Sqrt]; 
    Unprotect[Power]; \@p_\^2 := 
      p /; Positive[p]; \@\(p_*q_\) := \(\@p\) \@q /; 
        Positive[p] && Positive[q]; Protect[Power]; Protect[Sqrt];\), "\n", 
    \(\(Unprotect[Positive];\)\), "\n", 
    \(\(Positive[
          Sin[\[Theta]]] = \(Positive[
            r] = \(Positive[\[Rho]] = \(Positive[
                u] = \(Positive[
                  v] = \(Positive[
                    w] = \(Positive[
                      y] = \(Positive[
                        x + \@\(x\^2 + y\^2\)] = \(Positive[\@p_] = \
\(Positive[p_\^2] = \(Positive[p_\^2 + q_\^2] = 
                            True\)\)\)\)\)\)\)\)\)\);\)\), "\n", 
    \(Positive[\(-\@p_\)] = False; 
    Positive[p_\ q_] = Positive[p] && Positive[q]; 
    Positive[1\/p_] = Positive[p];\), "\n", 
    \(\(Protect[Positive];\)\), "\n", 
    \(Unprotect[ArcTan]; 
    ArcTan[\[Rho]\ Cos[\[Theta]], \[Rho]\ Sin[\[Theta]]] = \[Theta]; 
    ArcTan[r\ Cos[\[Phi]]\ Sin[\[Theta]], 
        r\ Sin[\[Theta]]\ Sin[\[Phi]]] = \[Phi]; Protect[ArcTan];\), "\n", 
    \(Unprotect[ArcCos]; ArcCos[Cos[\[Theta]]] = \[Theta]; 
    Protect[ArcCos];\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(todospositivos[x_List] := 
      Positive[x[\([1]\)]] && Positive[x[\([2]\)]] && 
        Positive[x[\([3]\)]]\)], "Input",
  InitializationCell->True],

Cell["<<Graphics`Animation`", "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"],

Cell[BoxData[{
    \(\(g[r_, \[Theta]_, \[Phi]_] := {r\ Cos[\[Phi]]\ Sin[\[Theta]], 
          r\ Sin[\[Phi]]\ Sin[\[Theta]], 
          r\ Cos[\[Theta]]};\)\), "\[IndentingNewLine]", 
    \(\(planoscoordenados[
          r_, \[Theta]_, \[Phi]_] := {ParametricPlot3D[
            Evaluate[g[r, tz, fi]], {tz, 0, \[Pi]}, {fi, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity], 
          ParametricPlot3D[
            Evaluate[g[u, \[Theta], v]], {u, 0, 3.5}, {v, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity], 
          ParametricPlot3D[
            Evaluate[g[\[Rho], th, \(-\[Phi]\)]], {\[Rho], 0, 3.5}, {th, 
              0, \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]};\)\), "\[IndentingNewLine]", 
    \(fg[1] = planoscoordenados[1, \[Pi]/3 -  .9, \(-\[Pi]\)/2. ]; 
    fg[2] = planoscoordenados[1, \[Pi]/3 -  .625, \(-\[Pi]\)/2. ];\), "\n", 
    \(\(fg[3] = 
        planoscoordenados[1, \[Pi]/3 -  .4, \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[4] = 
        planoscoordenados[1, \[Pi]/3 -  .125, \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[5] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[6] = 
        planoscoordenados[1, \[Pi]/3. , \(-3\) \[Pi]/8. ];\)\), "\n", 
    \(\(fg[7] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/4. ];\)\), "\n", 
    \(\(fg[8] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/8. ];\)\), "\n", 
    \(\(fg[9] = planoscoordenados[1, \[Pi]/3. , 0. ];\)\), "\n", 
    \(\(fg[10] = planoscoordenados[1.25, \[Pi]/3. , 0. ];\)\), "\n", 
    \(fg[11] = planoscoordenados[1.5, \[Pi]/3. , 0. ]; 
    fg[12] = planoscoordenados[1.75, \[Pi]/3. , 0. ];\), "\n", 
    \(\(fg[13] = planoscoordenados[2, \[Pi]/3. , 0. ];\)\), "\n", 
    \(\(esfericasmovie := 
        Table[Show[{Graphics3D[{Thickness[ .01], 
                  Line[{{\(-4\), 0, 0}, {4, 0, 
                        0}}], \[IndentingNewLine]Line[{{0, \(-4\), 0}, {0, 4, 
                        0}}], Line[{{0, 0, \(-4\)}, {0, 0, 4}}], 
                  Text["\<x\>", {4, 0, 0}, {\(-1.25\), 1}], 
                  Text["\<y\>", {0, 4, 0}, {\(-1\), 
                      1}], \[IndentingNewLine]Text["\<z\>", {0, 0, 
                      4}, {0, \(-1.25\)}]}], 
              Graphics3D[{Hue[0], PointSize[ .03], Point[g[2, \[Pi]/3, 0]]}], 
              fg[k]}, Boxed \[Rule] False, Axes -> None, 
            PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 4}}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            ImageSize \[Rule] {527.25, 404.375}], {k, 1, 13}];\)\)}], "Input",\

  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Coordenadas polares", "Section"],

Cell[TextData[{
  "La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`g(\[Rho], \[Theta]) = 
        \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\)]],
  " es una biyecci\[OAcute]n de",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(\[CapitalOmega] = \),
              "TraditionalForm"], 
            FormBox[\(\(\[DoubleStruckCapitalR]\^+\)\[Times]\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  "]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "] sobre ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)]],
  ". Los n\[UAcute]meros \[Rho] y \[Theta] dados por ",
  Cell[BoxData[
      \(TraditionalForm\`x = \[Rho]\ cos\ \[Theta], \ 
      y = \[Rho]\ sen\ \[Theta]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] > 0\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(-\[Pi]\),
            "TraditionalForm"], "<", "\[Theta]", "\[LessEqual]", "\[Pi]"}], 
        TraditionalForm]]],
  " se llaman las coordenadas polares del punto de coordenadas cartesianas  ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(\(coordpolares;\)\)], "Input"],

Cell[TextData[{
  "En vez de elegir el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(-\[Pi]\), \[Pi]\)\)\)]],
  "] para medir en radianes el ",
  StyleBox["\[AAcute]ngulo polar",
    FontWeight->"Bold"],
  " \[Theta], podemos elegir cualquier otro intervalo semiabierto de longitud \
2\[Pi], por ejemplo [",
  Cell[BoxData[
      \(TraditionalForm\`0, 2  \[Pi]\)]],
  "[. La elecci\[OAcute]n m\[AAcute]s conveniente desde un punto de vista \
matem\[AAcute]tico, por razones de c\[AAcute]lculo (definici\[OAcute]n del \
arcotangente) y de simetr\[IAcute]a,  es ]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "]. Observa que lo que hacemos es medir \[AAcute]ngulos en sentido \
antihorario desde la parte negativa del eje de abscisas. Los valores de \
\[Theta] en el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), 0\)]],
  "[ corresponden a puntos situados en el semiplano inferior (",
  Cell[BoxData[
      \(TraditionalForm\`y < 0\)]],
  ") y valores de \[Theta] en el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`0, \[Pi]\)]],
  "[ corresponden a puntos situados en el semiplano superior (",
  Cell[BoxData[
      \(TraditionalForm\`y > 0\)]],
  "). Los valores de \[Theta] en el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2, \[Pi]/2\)]],
  "[ corresponden a puntos situados en el semiplano de la derecha (",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  ") y valores de \[Theta] en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\(\(\(]\) \(\[Pi]/
                  2\)\), \[Pi]\)\(]\)\)\(\[Union]\)\)\(]\)\) - \[Pi], \
\(-\[Pi]\)/\(\(2\)\([\)\)\)]],
  " corresponden a puntos situados en el semiplano de la izquierda (",
  Cell[BoxData[
      \(TraditionalForm\`x < 0\)]],
  "). "
}], "Text"],

Cell["\<\
Los siguientes comandos pasan de coordenadas polares a cartesianas y de \
cartesianas a polares.\
\>", "Text"],

Cell[BoxData[{
    \(\(polar2cart[{\[Rho]_, \[Theta]_}] = \(g[\[Rho]_, \[Theta]_] := {\[Rho]\
\ Cos[\[Theta]], \ \[Rho]\ Sin[\[Theta]]}\);\)\), "\n", 
    \(cart2polar[{x_, y_}] := {\@\(x\^2 + y\^2\), ArcTan[x, y]}\)}], "Input"],

Cell[TextData[{
  "El comando ArcTan[x,y] proporciona el valor de \[Theta] teniendo en cuenta \
el cuadrante donde est\[AAcute] situado el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((x, y)\)\ \)\)]],
  "para lo cual suma o resta \[Pi] al valor de ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[y\/x]\)]],
  ". Para ",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  " se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[x, y] = ArcTan[y\/x]\)]],
  " pero esa igualdad no es cierta cuando ",
  Cell[BoxData[
      \(TraditionalForm\`x < 0\)]],
  ". En muchos textos se afirma que el \[AAcute]ngulo polar, \[Theta], viene \
dado por la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = ArcTan[y\/x]\)]],
  ", debes tener claro que eso es falso cuando ",
  Cell[BoxData[
      \(TraditionalForm\`x < 0\)]],
  ". Recuerda que la funci\[OAcute]n arcotangente toma valores en el \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(] \(-\[Pi]\)/2\), \[Pi]/\(2[\)\)]],
  ". Para ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " en el segundo cuadrante (",
  Cell[BoxData[
      \(TraditionalForm\`x < 0, y > 0\)]],
  ") el \[AAcute]ngulo polar est\[AAcute] en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(] \[Pi]/2\), \(\[Pi][\ \)\)]],
  "y es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi] + ArcTan[y\/x]\)]],
  ", y para ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " en el tercer cuadrante (",
  Cell[BoxData[
      \(TraditionalForm\`x < 0, y < 0\)]],
  ") el \[AAcute]ngulo polar est\[AAcute] en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(] \(-\[Pi]\)\), \(-\[Pi]\)/\(2[\ \)\)]],
  "y es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[y\/x] - \[Pi]\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Cuando se utiliza el sistema de coordenadas polares los vectores se \
refieren a una base ortonormal ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " que se ha representado en la figura anterior. En el lenguaje \
t\[IAcute]pico de los textos de f\[IAcute]sica se dice que el vector ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Rho]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Rho] manteniendo \[Theta] constante y el vector  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Theta] manteniendo \[Rho] constante. En t\[EAcute]rminos \
matem\[AAcute]ticos, quiz\[AAcute]s m\[AAcute]s precisos, observa que el \
vector de posici\[OAcute]n del punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " es  ",
  Cell[BoxData[
      \(TraditionalForm
      \`g(\[Rho], \[Theta]) = 
        \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\)]],
  " su variaci\[OAcute]n con respecto a \[Rho] manteniendo \[Theta] constante \
es la derivada parcial respecto a \[Rho] y su variaci\[OAcute]n con respecto \
a \[Theta] manteniendo \[Rho] constante es la derivada parcial respecto a \
\[Theta]."
}], "Text"],

Cell[BoxData[{
    \(D[g[\[Rho], \[Theta]], \[Rho]]\), "\n", 
    \(D[g[\[Rho], \[Theta]], \[Theta]]\)}], "Input"],

Cell["Observa que estos vectores son ortogonales", "Text"],

Cell[BoxData[
    \(D[g[\[Rho], \[Theta]], \[Rho]] . D[g[\[Rho], \[Theta]], \[Theta]] // 
      Simplify\)], "Input"],

Cell[TextData[{
  "Para obtener una base ortonormal a partir de ellos todo lo que tenemos que \
hacer es normalizarlos. El primero tiene norma igual a 1 y el segundo tiene \
norma igual a \[Rho]. Por tanto, los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], "=", 
            \((cos\ \[Theta], \ sen\ \[Theta])\)}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "=", 
            \((\(-sen\)\ \[Theta], \ cos\ \[Theta])\)}]}], 
        TraditionalForm]]],
  " forman una base ortonormal. Es a dicha base a la que se refiere un vector \
cuando se usan coordenadas polares. Observa que los vectores de esta base \
dependen de la posici\[OAcute]n del punto, es decir, no se trata de una base \
fija. F\[IAcute]jate en que si ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((\[Rho], \[Theta])\)\ \)\)]],
  "son las coordenadas polares de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\((x, y)\), "=", 
          RowBox[{"\[Rho]", " ", 
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". En general, la expresi\[OAcute]n en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " de un vector  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", \((x, y)\)}], TraditionalForm]]],
  " se obtiene por el m\[EAcute]todo usual calculando sus proyecciones \
ortogonales sobre los vectores de la base:"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(v = \[LeftAngleBracket]v | e\_\[Rho]\[RightAngleBracket] 
                e\_\[Rho] + 
              \[LeftAngleBracket]v | e\_\[Theta]\[RightAngleBracket] 
                e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  "\t\t(1)"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que si escribimos ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", 
          \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)}], 
        TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[LeftAngleBracket]v | e\_\[Rho]\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", "\[Rho]"}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          
          StyleBox[
            \(\[LeftAngleBracket]v | e\_\[Theta]\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", "0"}], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  "Recuerda que la matriz jacobiana de una funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(f(x, y) = \((\(f\_1\)(x, y), \(f\_2\)(x, y))\)\ 
      \)\)]],
  "es la matriz cuyas filas son los vectores gradiente de las funciones \
componentes de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " . El siguiente comando calcula la matriz jacobiana de un campo vectorial \
de dos variables."
}], "Text"],

Cell[BoxData[
    \(\(matrizjacobiana2[func_]\)[x_, y_] := 
      Module[{u, v}, 
        Outer[D, func[u, v], {u, v}] /. {u -> x, v -> y}]\)], "Input"],

Cell[BoxData[
    \(\(matrizjacobiana2[g]\)[\[Rho], \[Theta]] // MatrixForm\)], "Input"],

Cell[TextData[{
  "Las columnas de la matriz jacobiana son las derivadas parciales ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(D[g[\[Rho], \[Theta]], \[Rho]]\)\(\ \)\)\)]],
  " y",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \ \)\(D[
        g[\[Rho], \[Theta]], \[Theta]]\)\)\)]],
  ". Las normas eucl\[IAcute]deas de las columnas de la matriz jacobiana se \
llaman ",
  StyleBox["factores m\[EAcute]tricos ",
    FontWeight->"Bold"],
  "o ",
  StyleBox["factores de escala",
    FontWeight->"Bold"],
  " del cambio a cordenadas polares y son ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \[Rho]}\)]],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
Expresi\[OAcute]n de la velocidad y la aceleraci\[OAcute]n en cordenadas \
polares\
\>", "Subsection"],

Cell[TextData[{
  "Consideremos un m\[OAcute]vil cuya trayectoria en el plano viene dada por \
la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{\(x(t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(y(t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". Sean ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Rho](t), \ \[Theta](t))\)\)]],
  " las coordenadas polares de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " de forma que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
          \((\(\[Rho](t)\) cos\ \(\[Theta](t)\), 
              \(\[Rho](t)\) sen\ \(\[Theta](t)\))\), "=", 
            RowBox[{\(\[Rho](t)\), 
              RowBox[{
                StyleBox[\(e\_\[Rho]\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          \((cos\ \(\[Theta](t)\), sen\ \(\[Theta](t)\))\)}], 
        TraditionalForm]]],
  ". Observa que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Rho]\%\(\ \[VerticalLine]\)\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["\[Theta]", 
                  RowBox[{" ", 
                    StyleBox["\[VerticalLine]",
                      FontWeight->"Bold"]}]], "(", "t", ")"}], 
              \((\(-sen\)\ \(\[Theta](t)\), cos\ \(\[Theta](t)\))\)}], "=", 
            RowBox[{
              RowBox[{
                SuperscriptBox["\[Theta]", 
                  RowBox[{" ", 
                    StyleBox["\[VerticalLine]",
                      FontWeight->"Bold"]}]], "(", "t", ")"}], 
              RowBox[{
                StyleBox[\(e\_\[Theta]\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]],
  ". Tenemos que "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
            RowBox[{
              RowBox[{
                RowBox[{\(\[Rho]'\), \((t)\), 
                  RowBox[{
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                RowBox[{\(\[Rho](t)\), 
                  RowBox[{
                    StyleBox[\(e\_\[Rho]\%\(\ \[VerticalLine]\)\),
                      FontWeight->"Bold"], "(", "t", ")"}]}]}], "=", 
              RowBox[{
                RowBox[{\(\[Rho]'\), \((t)\), 
                  RowBox[{
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                \(\(\[Rho](t)\) \[Theta]\ ' \((t)\)\)}]}]}],
          "TraditionalForm"], 
        RowBox[{
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que es la expresi\[OAcute]n de la velocidad en coordenadas polares. \
Derivando la expresi\[OAcute]n anterior y teniendo en cuenta que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Theta]\%\(\ \[VerticalLine]\)\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                SuperscriptBox["\[Theta]", 
                  RowBox[{" ", 
                    StyleBox["\[VerticalLine]",
                      FontWeight->"Bold"]}]], "(", "t", ")"}]}], 
            RowBox[{
              StyleBox[\(e\_\[Rho]\),
                FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]],
  " puedes comprobar que la aceleraci\[OAcute]n viene dada por:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], "'"}], \((t)\)}], "=", 
            RowBox[{
              RowBox[{
              \((\(\[Rho]'\)' \((t)\) - 
                    \(\[Rho](t)\) \((\[Theta]\ ' \((t)\))\)\^2)\), 
                RowBox[{
                  StyleBox[\(e\_\[Rho]\),
                    FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
              \((2  \[Rho]' \((t)\) \[Theta]\ '\ \((t)\) + 
                  \(\[Rho](t)\) \(\[Theta]\ '\)\ ' \((t)\))\)}]}],
          "TraditionalForm"], 
        RowBox[{
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Nota",
    FontWeight->"Bold"],
  ". En algunos libros de f\[IAcute]sica se usa la notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Rho]\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(\[Rho]\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " (o  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Rho]\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(r\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ") y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(\[Theta]\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " y se les da a estos vectores el extra\[NTilde]o nombre de ",
  StyleBox["versores. ",
    FontSlant->"Italic"],
  "Todav\[IAcute]a nadie me ha sabido explicar qu\[EAcute] es un versor.  "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expresi\[OAcute]n de la divergencia en cordenadas polares", "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
            \((\(f\_1\)(x, y), \(f\_2\)(x, y))\)}], " "}], 
        TraditionalForm]]],
  " un campo vectorial de dos variables. La divergencia de este campo es el \
campo escalar dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"div", 
          FormBox[
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
              \(\(\[PartialD]f\_1\/\[PartialD]x\) \((x, y)\) + 
                \(\[PartialD]f\_2\/\[PartialD]y\) \((x, y)\)\)}],
            "TraditionalForm"]}], TraditionalForm]]],
  ". Consideremos la expresi\[OAcute]n de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en coordenadas polares:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(\[Rho], \[Theta]\), ")"}], "=", 
        RowBox[{
          RowBox[{
            StyleBox["f",
              FontWeight->"Bold"], "(", \(\[Rho]\ cos\ \[Theta], 
            \[Rho]\ sen\ \[Theta]\), ")"}], "=", 
          \((\(f\_1\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta]), 
            \(f\_2\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta]))\)}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y calculemos las componentes ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Rho]\)(\[Rho], \[Theta])\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(F\_\[Theta]\)(\[Rho], \[Theta])\ \)\)]],
  " de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(\[Rho], \[Theta]\), ")"}], 
        TraditionalForm]]],
  " respecto de la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ", esto es,  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(\[Rho], \[Theta]\), ")"}], "=", 
          RowBox[{
            RowBox[{\(\(F\_\[Rho]\)(\[Rho], \[Theta])\), 
              StyleBox[\(e\_\[Rho]\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\(F\_\[Theta]\)(\[Rho], \[Theta])\), 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". Sabemos que dichas componentes viene dadas por las correspondientes \
proyecciones ortogonales:"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      
                      FormBox[\(\(F\_\(\(\[Rho]\)\(\ \)\)\)(\[Rho], \[Theta]) \
= \[LeftAngleBracket]\),
                        "TraditionalForm"], 
                      RowBox[{
                        StyleBox["F",
                          FontWeight->"Bold"], 
                        "(", \(\[Rho], \ \ \ \[Theta]\), ")"}]}], "|", 
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"]}], 
                  StyleBox["\[RightAngleBracket]",
                    FontWeight->"Bold"]}], "="}],
              "TraditionalForm"], 
            
            FormBox[\(\(f\_1\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\),
              "TraditionalForm"], "cos", " ", "\[Theta]"}], 
          "+", \(\(\(f\_2\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\) 
            sen\ \[Theta]\)}], TraditionalForm]]],
  "\n   ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    
                    FormBox[\(\(F\_\(\(\[Theta]\)\(\ \)\)\)(\[Rho], \[Theta]) \
= \[LeftAngleBracket]\),
                      "TraditionalForm"], 
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold"], "(", \(\[Rho], \ \ \ \[Theta]\), 
                      ")"}]}], "|", 
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"]}], "\[RightAngleBracket]"}], "="}],
            "TraditionalForm"], "-", 
          RowBox[{
            
            FormBox[\(\(f\_1\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\),
              "TraditionalForm"], "sen", " ", "\[Theta]"}], 
          "+", \(\(\(f\_2\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\) 
            cos\ \[Theta]\)}], TraditionalForm]]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para obtener la expresi\[OAcute]n de la divergencia de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " en coordenadas polares debemos expresar la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              RowBox[{"div", 
                StyleBox["f",
                  FontWeight->"Bold",
                  
                  FontSlant->
                    "Italic"]}]], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}], "=", 
          RowBox[{
            RowBox[{
              FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
                
                "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}], "+", 
            RowBox[{
              FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
                
                "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}]}]}], TextForm]]],
  " en t\[EAcute]rminos de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`F\_\[Rho], \ F\_\[Theta]\)]],
  " y de sus derivadas parciales. Hay dos formas de hacer esto. "
}], "Text"],

Cell["De forma indirecta", "Text",
  FontWeight->"Bold"],

Cell["\<\
Derivamos en las igualdades anteriores haciendo uso de la regla de la cadena \
(derivaci\[OAcute]n de una funci\[OAcute]n compuesta). Tenemos que:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], 
                "\[Rho]"]}], \(\[PartialD]\[Rho]\)], \((\[Rho], \[Theta])\)}],
         "=", 
        RowBox[{
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), \(cos\^2\), " ", "\[Theta]"}], " ", "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), "cos", " ", "\[Theta]", " ", "sen", " ", "\[Theta]"}], "+", 
          "\[IndentingNewLine]", "                        ", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]x\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), "cos", " ", "\[Theta]", " ", "sen", " ", "\[Theta]"}], "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), \(sen\^2\), " ", "\[Theta]"}]}]}], TextForm]], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], 
                "\[Theta]"]}], \(\[PartialD]\[Theta]\)], \((\[Rho], \[Theta])\
\)}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
                
                "TraditionalForm"]}], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), \((\(-\[Rho]\)\ sen\ \[Theta])\), "sen", " ", "\[Theta]"}], " ", 
          "-", 
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), "\[Rho]", " ", "cos", " ", "\[Theta]", " ", "sen", " ", 
            "\[Theta]"}], "-", 
          RowBox[{
            SubscriptBox[
              StyleBox["f",
                FontSlant->"Italic"], 
              "1"], \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\), 
            "cos", " ", "\[Theta]"}], "+", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]x\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), \((\(-\[Rho]\)\ sen\ \[Theta])\), " ", "cos", " ", "\[Theta]"}], 
          "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), "\[Rho]", " ", \(cos\^2\), " ", "\[Theta]"}], "-", 
          RowBox[{
            SubscriptBox[
              StyleBox["f",
                FontSlant->"Italic"], 
              "2"], \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\), 
            "sen", " ", "\[Theta]"}]}]}], TextForm]], "Text"],

Cell[TextData[
"Sumando estas igualdades, despu\[EAcute]s de dividir por \[Rho] la segunda \
de ellas, se deduce que"], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "\[Rho]"]}], 
              \(\[PartialD]\[Rho]\)], \((\[Rho], \[Theta])\)}], "+", 
          RowBox[{\(1\/\[Rho]\), 
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "\[Theta]"]}], 
              \(\[PartialD]\[Theta]\)], \((\[Rho], \[Theta])\)}]}], "=", 
        RowBox[{
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
              "TraditionalForm"], 
            \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}], "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
              "TraditionalForm"], 
            \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}], "-", 
          RowBox[{\(1\/\[Rho]\), 
            SubscriptBox[
              StyleBox["F",
                FontSlant->"Italic"], "\[Rho]"], 
            \((\[Rho], \[Theta])\)}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[" es decir", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox[
            RowBox[{"div", 
              StyleBox["f",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]], 
          \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
                "TraditionalForm"], 
              \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}], "+", 
            RowBox[{
              FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
                "TraditionalForm"], 
              \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}]}], "=", 
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], "\[Rho]"]}], 
                \(\[PartialD]\[Rho]\)], \((\[Rho], \[Theta])\)}], "+", 
            RowBox[{\(1\/\[Rho]\), 
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], "\[Theta]"]}], 
                \(\[PartialD]\[Theta]\)], \((\[Rho], \[Theta])\)}], "+", 
            RowBox[{\(1\/\[Rho]\), 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "\[Rho]"], 
              \((\[Rho], \[Theta])\)}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["igualdad que suele escribirse en la forma", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"div", " ", 
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "\[Rho]"]}], \(\[PartialD]\[Rho]\)], 
          "+", 
          RowBox[{\(1\/\[Rho]\), 
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "\[Theta]"]}], 
              \(\[PartialD]\[Theta]\)]}], "+", 
          RowBox[{\(1\/\[Rho]\), 
            SubscriptBox[
              StyleBox["F",
                FontSlant->"Italic"], "\[Rho]"]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["e incluso m\[AAcute]s condesado, en la forma", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{"div", " ", 
            StyleBox["f",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            RowBox[{\(1\/\[Rho]\), \(\[PartialD]\/\[PartialD]\[Rho]\), 
              RowBox[{"(", 
                RowBox[{"\[Rho]", " ", 
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], "\[Rho]"]}], ")"}]}], "+", 
            RowBox[{\(1\/\[Rho]\), 
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], 
                    "\[Theta]"]}], \(\[PartialD]\[Theta]\)]}]}]}]], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y se dice que dicha expresi\[OAcute]n proporciona la divergencia de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en polares. "
}], "Text"],

Cell["De forma directa", "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "El camino que hemos seguido antes para obtener la expresi\[OAcute]n de la \
divergencia en coordenadas polares es un ",
  StyleBox["camino indirecto",
    FontSlant->"Italic"],
  ", pues hemos calculado las derivadas ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"\[PartialD]", 
            SubscriptBox[
              StyleBox["F",
                FontSlant->"Italic"], "\[Rho]"]}], \(\[PartialD]\[Rho]\)], 
        TextForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"\[PartialD]", 
            SubscriptBox[
              StyleBox["F",
                FontSlant->"Italic"], "\[Theta]"]}], \(\[PartialD]\[Theta]\)],
         TextForm]]],
  " y, al hacerlo, ",
  StyleBox["nos hemos dado cuenta",
    FontSlant->"Italic"],
  " de que pod\[IAcute]amos hacer una operaci\[OAcute]n sencilla con ellas \
para relacionarlas con ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}], "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}]}], TextForm]]],
  ". Un camino m\[AAcute]s natural consiste en expresar ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_1\)(x, y)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_2\)(x, y)\)]],
  " en funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Rho]\)(\[Rho], \[Theta])\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Theta]\)(\[Rho], \[Theta])\)]],
  "; es decir, se trata de obtener las coordenadas cartesianas ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(f\_1\)(x, y), \(f\_2\)(x, y))\)\)]],
  " del vector",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["f",
              FontWeight->"Bold"], "(", \(x, y\), ")"}]}], 
        TraditionalForm]]],
  " en funci\[OAcute]n de las coordenadas de dicho vector respecto de la base \
",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". Basta para ello tener en cuenta que: "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\((\(f\_1\)(x, y), \(f\_2\)(x, y))\), "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\(F\_\[Rho]\)(\[Rho], \[Theta])\), 
              SubscriptBox[
                StyleBox["e",
                  FontWeight->"Bold"], 
                StyleBox["\[Rho]",
                  FontWeight->"Bold"]]}], "+", 
            RowBox[{\(\(F\_\[Theta]\)(\[Rho], \[Theta])\), 
              SubscriptBox[
                StyleBox["e",
                  FontWeight->"Bold"], 
                StyleBox["\[Theta]",
                  FontWeight->"Bold"]]}]}], "=", 
          RowBox[{
            RowBox[{"(", GridBox[{
                  {\(cos\ \[Theta]\), \(\(-sen\)\ \[Theta]\)},
                  {\(sen\ \[Theta]\), \(cos\ \[Theta]\)}
                  }], ")"}], 
            RowBox[{"(", GridBox[{
                  {\(\(F\_\[Rho]\)(\[Rho], \[Theta])\)},
                  {\(\(F\_\[Theta]\)(\[Rho], \[Theta])\)}
                  }], ")"}], " "}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es decir, la matriz cuyas columnas son los vectores ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\(\(\[Rho]\)\(\ \)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "y ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es justamente la matiz del cambio de base que necesitamos. Naturalmente, \
en esta igualdad debemos ver a \[Rho] y a \[Theta] como funciones de ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho](x, y) = \@\(x\^2 + y\^2\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta](x, y) = ArcTan\ [x, y]\)]],
  ". Vamos a pedirle ayuda a ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "para hacer los c\[AAcute]lculos. "
}], "Text"],

Cell[BoxData[{
    \(\(\[Rho][x_, y_] := \@\(x\^2 + y\^2\);\)\), "\n", 
    \(\(\[Theta][x_, y_] := ArcTan[x, y];\)\), "\n", 
    \(\(A = 
        Transpose[{{Cos[\[Theta][x, y]], 
              Sin[\[Theta][x, y]]}, {\(-Sin[\[Theta][x, y]]\), 
              Cos[\[Theta][x, y]]}}];\)\), "\n", 
    \(f1[x_, 
        y_] = \((A . {F\[Rho][\[Rho][x, y], \[Theta][x, y]], 
              F\[Theta][\[Rho][x, y], \[Theta][x, y]]})\)[\([1]\)]\), "\n", 
    \(f2[x_, 
        y_] = \((A . {F\[Rho][\[Rho][x, y], \[Theta][x, y]], 
              F\[Theta][\[Rho][x, y], \[Theta][x, 
                  y]]})\)[\([2]\)]\)}], "Input"],

Cell[TextData[{
  "Una vez que disponemos de ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_1\)(x, y)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_2\)(x, y)\)]],
  " en funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(F\_\[Rho]\)(\@\(x\^2 + y\^2\), \ ArcTan[x, y])\)]],
  " y de ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(F\_\[Theta]\)(\@\(x\^2 + y\^2\), \ ArcTan[x, y])\)]],
  ", todo lo que tenemos que hacer es calcular las derivadas parciales ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]f\_1\/\[PartialD]x\) \((x, y)\), 
      \(\[PartialD]f\_2\/\[PartialD]y\) \((x, y)\)\)]],
  " sumarlas, simplificar y sustituir ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)\)]],
  ". Esto lo hace ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " siempre que le demos una ayudita para que simplifique bien las \
ra\[IAcute]ces cuadradas (por ejemplo para que ",
  Cell[BoxData[
      \(TraditionalForm\`\@\[Rho]\^2\)]],
  "lo simplifique igual a \[Rho]) y para que sustituya ArcTan[\[Rho] Cos[\
\[Theta]], \[Rho] Sin[\[Theta]]] por \[Theta]. Esta ayudita la hemos incluido \
en las celdas de inicializaci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(\((\((D[f1[x, y], x] + D[f2[x, y], y] // 
              Simplify)\) /. {x -> \[Rho]\ Cos[\[Theta]], 
            y -> \[Rho]\ Sin[\[Theta]]})\) // Simplify\)], "Input"],

Cell["Que como puedes ver es la misma expresi\[OAcute]n obtenida antes.", 
  "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Gradiente y elemento diferencial de longitud en coordenadas polares\
\>", "Subsection"],

Cell[TextData[{
  "Sea ",
  StyleBox["f",
    FontSlant->"Italic"],
  " un campo escalar de dos variables. Sabemos que el gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  es el campo vectorial dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(f(x, y)\)\), "=", 
          RowBox[{
            RowBox[{\(\[PartialD]f\/\[PartialD]x\), \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".  Hagamos en esta igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 
          y)\) = \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\)]],
  " para obtener"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\
\), "=", 
          RowBox[{
            
            RowBox[{\(\[PartialD]f\/\[PartialD]x\), \((\[Rho]\ cos\ \[Theta], \
\ \[Rho]\ sen\ \[Theta])\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((\[Rho]\ cos\ \[Theta], \
\ \[Rho]\ sen\ \[Theta])\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La expresi\[OAcute]n del gradiente de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en polares viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\
\), "=", 
          RowBox[{
            RowBox[{\(\(f\_\[Rho]\)(\[Rho], \[Theta])\), 
              StyleBox[\(e\_\[Rho]\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\(f\_\[Theta]\)(\[Rho], \[Theta])\), 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Rho]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Theta]\)]],
  " son las componentes del vector ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \
\[Theta])\)\)]],
  " en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". Dichas componentes sabemos que vienen dadas por"
}], "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            
            FormBox[\(\(f\_\[Rho]\)(\[Rho], \[Theta]) = \[LeftAngleBracket]\),
              
              
              "TraditionalForm"], \(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\
\ sen\ \[Theta])\)\), " ", 
            FormBox[
              RowBox[{"|", 
                StyleBox[\(e\_\[Rho]\),
                  FontWeight->"Bold"]}],
              "TraditionalForm"]}], "\[RightAngleBracket]"}], 
        "=", \(\(\[PartialD]f\/\[PartialD]x\) \((\[Rho]\ cos\ \[Theta], \ \
\[Rho]\ sen\ \[Theta])\)\ cos\ \[Theta] + \(\[PartialD]f\/\[PartialD]y\) \((\
\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\ sen\ \[Theta]\)}], 
      TraditionalForm], "\n", 
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              
              FormBox[\(\(f\_\[Theta]\)(\[Rho], \[Theta]) = \
\[LeftAngleBracket]\),
                
                "TraditionalForm"], \(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \
\[Rho]\ sen\ \[Theta])\)\), " ", 
              FormBox[
                RowBox[{"|", 
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"]}],
                "TraditionalForm"]}], "\[RightAngleBracket]"}], 
          "=", \(\(-\(\[PartialD]f\/\[PartialD]x\)\) \((\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\)\ sen\ \[Theta] + \(\[PartialD]f\/\
\[PartialD]y\) \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\ cos\ \
\[Theta]\)}],
        "TraditionalForm"], TraditionalForm]}], "Text",
  TextAlignment->Center],

Cell["que podemos escribir como sigue", "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\(\(f\_\[Rho]\)(\[Rho], \[Theta])\)\(=\)\),
              
              "TraditionalForm"], \(\[PartialD]f\/\[PartialD]x\), \((\[Rho]\ \
cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\), \(\[PartialD]\((\[Rho]\ \ cos\ \
\[Theta])\)\/\[PartialD]\[Rho]\)}], 
          "+", \(\(\[PartialD]f\/\[PartialD]y\) \((\[Rho]\ cos\ \[Theta], \ \
\[Rho]\ sen\ \[Theta])\)\ \[PartialD]\((\[Rho]\ \ sen\ \[Theta])\)\/\
\[PartialD]\[Rho]\)}], 
        "=", \(\(\[PartialD]\/\[PartialD]\[Rho]\) 
          f \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)\)}], 
      TraditionalForm], "\n", 
    FormBox[
      RowBox[{\(\(f\_\[Theta]\) \((\[Rho], \[Theta])\)\), "=", 
        RowBox[{\(1\/\[Rho]\), 
          
          FormBox[\(\((\( \(\[PartialD]f\/\[PartialD]x\)\) \((\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\)\ \[PartialD]\((\[Rho]\ \ cos\ \
\[Theta])\)\/\[PartialD]\[Theta] + \(\[PartialD]f\/\[PartialD]y\) \((\[Rho]\ \
cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\ \[PartialD]\((\[Rho]\ \ sen\ \
\[Theta])\)\/\[PartialD]\[Theta])\) = \(1\/\[Rho]\) \
\(\[PartialD]\/\[PartialD]\[Theta]\) \(f(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)\),
            "TraditionalForm"]}]}], TraditionalForm]}], "Text",
  TextAlignment->Center],

Cell["Hemos obtenido as\[IAcute] que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\),
         "=", 
        RowBox[{
          
          RowBox[{\(\[PartialD]\/\[PartialD]\[Rho]\), \(f(\[Rho]\ cos\ \
\[Theta], \[Rho]\ sen\ \[Theta])\), 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Rho]"]}], "+", 
          
          RowBox[{\(1\/\[Rho]\), \(\[PartialD]\/\[PartialD]\[Theta]\), \(f(\
\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\), 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Theta]"], 
            "                          ", \((1)\), "      "}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es conveniente introducir la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`h(\[Rho], \[Theta]) = 
        f(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)]],
  " con lo que la igualdad (1) se escribe mejor en la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\),
         "=", 
        RowBox[{
          
          RowBox[{\(\[PartialD]h\/\[PartialD]\[Rho]\), \((\[Rho]\ , \ \
\[Theta])\), 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Rho]"]}], "+", 
          
          RowBox[{\(1\/\[Rho]\), \(\[PartialD]h\/\[PartialD]\[Theta]\), \((\
\[Rho], \[Theta])\), 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Theta]"], 
            "                                   ", \((2)\), "        "}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que en esta igualdad a la izquierda tenemos el gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " calculado en la expresi\[OAcute]n de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en coordenadas cartesianas y evaluado en el punto (\[Rho]",
  " cos \[Theta], \[Rho] sen \[Theta]), y a la derecha lo que tenemos son las \
derivadas parciales de la funci\[OAcute]n compuesta ",
  Cell[BoxData[
      \(TraditionalForm\`h(\[Rho], \[Theta]) = 
        f(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)]],
  " evaluadas en el punto (\[Rho],\[Theta]). En los textos de f\[IAcute]sica \
es frecuente que no se distinga entre la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  y la funci\[OAcute]n ",
  StyleBox["h",
    FontSlant->"Italic"],
  " (pues, en definitiva, son la ",
  StyleBox["misma funci\[OAcute]n ",
    FontSlant->"Italic"],
  "expresada en ",
  StyleBox["distintas",
    FontSlant->"Italic"],
  " coordenadas) y que escriban la igualdad (1) en la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FrameBox[
          RowBox[{\(\[Del]f\), "=", 
            RowBox[{
              RowBox[{\(\[PartialD]f\/\[PartialD]\[Rho]\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold"], "\[Rho]"]}], "+", 
              RowBox[{\(1\/\[Rho]\), \(\[PartialD]f\/\[PartialD]\[Theta]\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold"], \(\(\[Theta]\)\(\ \)\)], 
                "        "}]}]}]], 
        "                                     ", \((3)\), "      "}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
igualdad que constituye la \"expresi\[OAcute]n del gradiente en polares\". \
\>", "Text"],

Cell[TextData[{
  "Observa que en la expresi\[OAcute]n anterior del gradiente aparecen los \
inversos de los factores de escala multiplicando a las derivadas parciales a \
las que est\[AAcute] asociado cada uno de ellos. Como sabes, los factores de \
escala son ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \[Rho]}\)]],
  "; el primero de ellos, 1, est\[AAcute] asociado a la primera columna de la \
matriz jacobiana del cambio de coordenadas que corresponde a la derivaci\
\[OAcute]n parcial respecto a la primera variable, \[Rho]; el segundo de \
ellos, \[Rho], est\[AAcute] asociado a la segunda columna de la matriz \
jacobiana del cambio de coordenadas que corresponde a la derivaci\[OAcute]n \
parcial respecto a la segunda variable, \[Theta]. "
}], "Text"],

Cell["\<\
Hemos visto antes que la velocidad en coordenadas polares se expresa por\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
              RowBox[{
                RowBox[{\(\[Rho]'\), \((t)\), 
                  RowBox[{
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], 
                "+", \(\(\[Rho](t)\) \[Theta]\ ' \((t)\)\)}]}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]],
  "\t\t(4)"
}], "Text",
  TextAlignment->Center],

Cell["\<\
Esta igualdad suele escribirse con notaci\[OAcute]n m\[AAcute]s \
cl\[AAcute]sica en la forma\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[DifferentialD]", 
            FormBox[
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "=", 
                RowBox[{
                  RowBox[{\(\[DifferentialD]\[Rho]\), " ", 
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"]}], "+", "\[Rho]"}]}],
              "TraditionalForm"]}], \(\[DifferentialD]\[Theta]\), " ", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  "\t\t"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Imaginemos ahora que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["es",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["la",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["funci\[OAcute]n",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["de",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["trayectoria",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["de",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["un",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["m\[OAcute]vil",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox[Cell["y"],
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  "que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
              FormBox[Cell[TextData[Cell[BoxData[
                    FormBox[
                      RowBox[{
                        StyleBox["r",
                          FontWeight->"Bold"], "(", "a", ")"}], 
                      TraditionalForm]]]]], TraditionalForm]]]]]}], 
        TraditionalForm]]],
  "es su punto inicial; entonces la distancia, ",
  Cell[BoxData[
      \(TraditionalForm\`s(t)\)]],
  ", recorrida por el m\[OAcute]vil en cada momento ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " viene dada por "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(s \((t)\)\), "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%t\), 
            RowBox[{"||", 
              RowBox[{
                StyleBox[\(r'\),
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], \((t)\)}], 
              "||", \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_a\%t\), 
              RowBox[{"||", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\(\[Rho]'\), \((t)\), 
                        RowBox[{
                          StyleBox[\(e\_\[Rho]\),
                            FontWeight->"Bold"], "(", "t", ")"}]}], 
                      "+", \(\(\[Rho](t)\) \[Theta]\ ' \((t)\)\)}],
                    "TraditionalForm"], 
                  RowBox[{
                    StyleBox[\(e\_\[Theta]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], 
                "||", \(\[DifferentialD]t\)}]}], 
            "=", \(\[Integral]\_a\%t\(\@\(\((\[Rho]' \((t)\))\)\^2 + \((\(\
\[Rho](t)\) \[Theta]\ ' \((t)\))\)\^2\)\) \(\(\[DifferentialD]\)\(t\)\(\ \ \ \
\ \ \ \ \ \ \)\)\)}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Y, por tanto, ",
  Cell[BoxData[
      \(TraditionalForm\`s' \((t)\) = \@\(\((\[Rho]' \((t)\))\)\^2 + \((\(\
\[Rho](t)\) \[Theta]\ ' \((t)\))\)\^2\)\)]],
  ". Esta igualdad suele escribirse en la forma"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\((\[DifferentialD]s)\)\^2 = \((\[DifferentialD]\
\[Rho])\)\^2 + \(\(\[Rho]\^2\)(\[DifferentialD]\[Theta]\ )\)\^2\)]],
  "\t"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y se llama ",
  StyleBox["elemento diferencial de longitud",
    FontSlant->"Italic"],
  " en coordenadas polares. Observa que aqu\[IAcute] aparecen los factores de \
escala 1 y \[Rho] elevados al cuadrado y multiplicando a las correspondientes \
\"diferenciales\" \[DifferentialD]\[Rho] y \[DifferentialD]\[Theta]. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Significado de los factores de escala", "Subsection"],

Cell["\<\
Consideremos la matriz jacobiana de la funci\[OAcute]n que introduce las \
coordenadas polares.\
\>", "Text"],

Cell[BoxData[
    \(A = \(matrizjacobiana2[g]\)[\[Rho], \[Theta]]\)], "Input"],

Cell[TextData[{
  "Esta matriz define una aplicaci\[OAcute]n lineal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " que a cada vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " hace corresponder el vector ",
  Cell[BoxData[
      \(TraditionalForm\`A . \((x, y)\)\)]],
  ". Calculemos la norma eucl\[IAcute]dea de la imagen de un vector en dicha \
transformaci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(\@\(\((A . {x, y})\) . \((A . {x, y})\)\) // Simplify\)], "Input"],

Cell[TextData[{
  "Deducimos que para vectores situados a lo largo del eje de abscisas, es \
decir, de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 0)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(||\)\(A . \((x, 
                0)\)\)\)\(||\)\) = \(\(||\)\((x, 0)\)\(||\)\)\)]],
  " y, teniendo en cuenta la linealidad, se sigue que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\(||\)\(A . \((x, 0)\)\)\) - 
            A . \((z, 0)\)\)\(||\)\) = \(\(\(||\)\(\((x, 0)\) - \((z, 
                0)\)\)\)\(||\)\)\)]],
  ", esto es, la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Rule] A . \((x, y)\)\)]],
  " conserva distancias en el eje X. Pues bien, este es el significado de que \
el factor de escala asociado a la primera variable sea igual a 1.\nDeducimos \
tambi\[EAcute]n que para vectores situados a lo largo del eje de ordenadas, \
es decir, de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, y)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(||\)\(A . \((0, 
                y)\)\)\)\(||\)\) = \[Rho] || \((0, y)\) || \)]],
  " y, teniendo en cuenta la linealidad, se sigue que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\(||\)\(A . \((0, y)\)\)\) - 
            A . \((0, w)\)\)\(||\)\) = \[Rho] || \((0, y)\) - \((0, 
              w)\) || \)]],
  ", esto es, la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Rule] A . \((x, y)\)\)]],
  " multiplica distancias por \[Rho] en el eje Y. Pues bien, este es el \
significado de que el factor de escala asociado a la segunda variable sea \
igual a \[Rho].\nEn resumen, los factores de escala indican las dilataciones \
a lo largo de los ejes que hace la aplicaci\[OAcute]n lineal asociada a la \
matriz jacobiana de la aplicaci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(g(\[Rho], \[Theta]) = \((\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\)\)\)\)]],
  ". Suele decirse que la aplicaci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es la que, a ",
  StyleBox["escala infinitesimal",
    FontSlant->"Italic"],
  ", produce esas dilataciones. La expresi\[OAcute]n \"escala infinitesimal\" \
se entiende de la siguiente forma. Supongamos que fijamos valores ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = \[Rho]\_0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \[Theta]\_0\)]],
  " y sea \[Delta]  un n\[UAcute]mero \"muy peque\[NTilde]o\" (lo que en los \
siglos XVII y XVIII se llamaba un \"infinit\[EAcute]simo\"; terminolog\
\[IAcute]a precient\[IAcute]fica que todav\[IAcute]a usan algunos textos de f\
\[IAcute]sica). Entonces, por la definici\[OAcute]n de derivada, tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\(\(||\)\(g(\[Rho]\_0 + \[Delta], \[Theta]\_0) - 
                g(\[Rho]\_0, \
\[Theta]\_0)\)\(||\)\(\(\[TildeEqual]\)\(\[Delta]\)\)\(||\)\(\(\[PartialD]g\/\
\[PartialD]\[Rho]\) \((\[Rho]\_0, \[Theta]\_0)\)\)\(||\)\) = \[Delta]\), 
          "                              ", "\n", 
          RowBox[{
            RowBox[{"||", 
              RowBox[{
                RowBox[{
                  StyleBox["g",
                    FontSlant->"Italic"], 
                  "(", \(\[Rho]\_0, \ \[Theta]\_0\  + \ \[Delta]\), ")"}], 
                " ", "-", " ", 
                RowBox[{
                  StyleBox["g",
                    FontSlant->"Italic"], "(", \(\[Rho]\_0, \ \[Theta]\_0\), 
                  ")"}]}], "||", " ", \(\(\[TildeEqual]\)\(\ \)\(\[Delta]\)\),
               "||", \(\(\[PartialD]g\/\[PartialD]\[Theta]\) \((\[Rho]\_0, \ \
\[Theta]\_0)\)\), "||"}], " ", "=", " ", \(\[Delta]\[Rho]\_0\), 
            "              "}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La primera igualdad nos dice que si efectuamos \"incrementos \
infinitesimales\" en la primera variable la aplicaci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " conserva distancias y la segunda igualdad nos dice que si efectuamos \
\"incrementos infinitesimales\" en la segunda variable la aplicaci\[OAcute]n \
",
  StyleBox["g ",
    FontSlant->"Italic"],
  "multiplica",
  StyleBox[" ",
    FontSlant->"Italic"],
  "las distancias por el correspondiente valor de la primera variable."
}], "Text"],

Cell[TextData[{
  "La expresi\[OAcute]n (5) del \"elemento diferencial de longitud\" en \
coordenadas polares tiene en cuenta dichos factores de escala. \n\
Naturalmente, para calcular la longitud de una curva dada por las ecuaciones \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          \((\(\[Rho](t)\) cos\ \(\[Theta](t)\), \ 
            \(\[Rho](t)\) sen\ \(\[Theta](t)\))\)}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ", lo que se hace es integrar la rapidez con que dicha curva se recorre:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"||", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "'"}], \((t)\)}], "||"}], "=", 
        \(\@\(\((\[Rho]' \((t)\)\ cos\ \(\[Theta](t)\) - 
                    \(\[Rho](t)\)\ \[Theta]\ ' \((t)\)\ sen\ \(\[Theta](t)\))
                  \)\^2 + 
              \((\[Rho]' \((t)\)\ sen\ \(\[Theta](t)\) + 
                    \(\[Rho](t)\)\ \[Theta]\ ' \((t)\)\ cos\ \(\[Theta](t)\))
                  \)\^2\ \ \) = 
          \@\(\[Rho]' \((t)\)\^2 + 
              \(\(\[Rho](t)\)\^2\) \[Theta]\ \ ' \((t)\)\^2\)\)}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "en consecuencia, la longitud de ",
  StyleBox["r ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{"||", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], \((t)\)}], "||", 
              \(\[DifferentialD]t\)}]}], "=", 
          \(\[Integral]\_a\%b
              \(\@\( \[Rho]' \((t)\)\^2 + 
                    \(\(\[Rho](t)\)\^2\) \[Theta]\ \ ' \((t)\)\^2\)\) 
              \[DifferentialD]t\)}], TraditionalForm]]],
  ". ",
  "Observa que el valor obtenido para ",
  Cell[BoxData[
      FormBox[
        RowBox[{"||", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "'"}], \((t)\)}], "||"}], 
        TraditionalForm]]],
  " pod\[IAcute]amos haberlo calculado directamente usando la igualdad (4)."
}], "Text"],

Cell[TextData[{
  "Al igual que cada factor de escala mide la dilataci\[OAcute]n \
infinitesimal a lo largo de un eje, el producto de los factores de escala, en \
nuestro caso \[Rho], mide el cambio en el \[AAcute]rea de un \
rect\[AAcute]ngulo a escala infinitesimal. El producto de los factores de \
escala es justamente el determinante jacobiano. Recuerda que la \
f\[OAcute]rmula del cambio de variables a coordenadas polares en una integral \
doble afirma que si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un campo escalar continuo en un conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  " se verifica que\t\t"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
                  y)\)\) = \[Integral]\(\[Integral]\_B\ \(\(f(\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\) \(\[Rho]\)\(\ \)\(d\) \((\[Rho], \
\[Theta])\)\(\ \)\)\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"B", "=", 
            RowBox[{"{", 
              RowBox[{\((\[Rho], \[Theta])\), ":", 
                RowBox[{
                  
                  FormBox[
                    \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\),
                    "TraditionalForm"], "\[Element]", " ", "A"}]}], 
              "}"}]}]}], TraditionalForm]]],
  ". Observa que ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es la expresi\[OAcute]n del conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " en coordenadas polares, es decir ",
  Cell[BoxData[
      \(TraditionalForm\`A = g(B)\)]],
  ", y que en la segunda integral se multiplica por \[Rho]. Si \
particularizamos la igualdad anterior para la funci\[OAcute]n constante ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 1\)]],
  " obtenemos"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[CapitalAAcute]rea \((g(B))\)\), "=", 
          
          FormBox[\(\[Integral]\(\[Integral]\_A 
                    1 \( d(x, 
                      y)\)\) = \[Integral]\(\[Integral]\_B\ \[Rho]\ \
\(d(\[Rho], \[Theta])\)\)\),
            "TraditionalForm"], " "}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es un rect\[AAcute]ngulo muy peque\[NTilde]o (un rect\[AAcute]ngulo ",
  StyleBox["infinitesimal",
    FontSlant->"Italic"],
  ") se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\_B\ \[Rho]\ \(d(\[Rho], \[Theta])\)\)\  
          \[TildeEqual] \ 
          \[Rho] \(\[Integral]\(\[Integral]\_B\ d(\[Rho], \[Theta])\)\) = 
        \[Rho]\ \(\[CapitalAAcute]rea(B)\)\)]],
  " y obtenemos ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalAAcute]rea(g(B))\  \[TildeEqual] \ 
        \[Rho]\ \(\[CapitalAAcute]rea(B)\)\)]],
  ". En los libros de f\[IAcute]sica se dice que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Rho] \[DifferentialD]\[Rho] \[DifferentialD]\[Theta]\)]],
  " es el \"",
  StyleBox["elemento diferencial de \[AAcute]rea",
    FontSlant->"Italic"],
  "\" en coordenadas polares. "
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordenadas esf\[EAcute]ricas", "Section"],

Cell[TextData[{
  "La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g(
          r, \[Theta], \[Phi]) = \((r\ sen\ \[Theta]\ cos\ \[Phi]\ , \ 
          r\ sen\ \[Theta]\ sen\ \[Phi], r\ cos\ \[Theta])\)\)]],
  " es una biyecci\[OAcute]n de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"\[CapitalOmega]", "=", 
                  
                  FormBox[\(\(\[DoubleStruckCapitalR]\^+\)\[Times]\([0, \
\[Pi]]\)\[Times]\),
                    "TraditionalForm"]}], "]"}], "-", "\[Pi]"}], ",", 
            "\[Pi]"}], "]"}], TraditionalForm]]],
  " sobre ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\\{\((0, 0, 0)\)}\)]],
  ".  Los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\((r, \[Theta], \ \[Phi])\)\)]],
  " dados por ",
  Cell[BoxData[
      \(TraditionalForm\`x = r\ sen\ \[Theta]\ cos\ \[Phi], \ 
      y = \ r\ sen\ \[Theta]\ sen\ \[Phi], \ z = r\ cos\ \[Theta]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`r > 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] \ \[Theta] \[LessEqual] \[Pi]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < \ \[Phi] \[LessEqual] \[Pi]\)]],
  ", se llaman las coordenadas esf\[EAcute]ricas del punto de cordenadas \
cartesianas ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(\(coordesfericas;\)\)], "Input"],

Cell[TextData[{
  StyleBox["Nota",
    FontWeight->"Bold"],
  ". La notaci\[OAcute]n y el orden en que se escriben las coordenadas esf\
\[EAcute]ricas var\[IAcute]a de unos textos a otros. Las definiciones \
anteriores son las mismas que se usan en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " y eso nos permitir\[AAcute] aprovechar en lo que sigue los comandos del \
programa. En muchos textos los papeles de \[Phi] y \[Theta] est\[AAcute]n \
intercambiados con respecto a los nuestros. \nPor lo que se refiere al \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(] \(-\[Pi]\)\), \[Pi]]\)\ \)\)]],
  "elegido para medir en radianes el \[AAcute]ngulo \[Phi], podemos hacer las \
mismas observaciones que las hechas para las coordenadas polares. Con \
frecuencia dicho intervalo se sustituye por",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([0, 2 \( \[Pi][\)\)\)\)]],
  " lo que, dicho sea de paso, complica las f\[OAcute]rmulas del cambio de \
cartesianas a esf\[EAcute]ricas. Cuando en un libro se usen coordenadas esf\
\[EAcute]ricas debes comprobar c\[OAcute]mo se definen dichas coordenadas."
}], "Text"],

Cell["\<\
El siguiente comando carga el paquete para an\[AAcute]lisis vectorial.\
\>", "Text"],

Cell[BoxData[
    \(<< Calculus`VectorAnalysis`\)], "Input"],

Cell["Los siguientes comandos no precisan explicaci\[OAcute]n.", "Text"],

Cell[BoxData[
    \(\(?\ Spherical\)\)], "Input"],

Cell[BoxData[
    \(Coordinates[Spherical]\)], "Input"],

Cell[BoxData[
    \(CoordinateRanges[Spherical]\)], "Input"],

Cell[BoxData[
    \(\(\(CoordinatesToCartesian[{r, \[Theta], \[Phi]}, Spherical]\)\( (*\ 
      paso\ de\ esf\[EAcute]ricas\ a\ cartesianas\ *) \)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(CoordinatesFromCartesian[{x, y, z}, Spherical]\)\( (*\ 
      paso\ de\ cartesianas\ a\ esf\[EAcute]ricas\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Cuando se utiliza el sistema de coordenadas esf\[EAcute]ricas los vectores \
se refieren a una base ortonormal ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], 
            StyleBox[",",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Phi]"]}], "}"}], TraditionalForm]]],
  " que se ha representado en la figura anterior (trasladada al punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  "). En el lenguaje t\[IAcute]pico de los textos de f\[IAcute]sica se dice \
que el vector ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_r\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta ",
  StyleBox["r",
    FontSlant->"Italic"],
  " manteniendo \[Theta] y \[Phi] constantes, el vector  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Theta] manteniendo ",
  StyleBox["r",
    FontSlant->"Italic"],
  " y \[Phi] constantes y el vector  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Phi]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Phi] manteniendo ",
  StyleBox["r",
    FontSlant->"Italic"],
  " y \[Theta] constantes. En t\[EAcute]rminos matem\[AAcute]ticos, quiz\
\[AAcute]s m\[AAcute]s precisos, observa que el vector de posici\[OAcute]n \
del punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " de cordenadas esf\[EAcute]ricas  ",
  Cell[BoxData[
      \(TraditionalForm\`\((r, \[Theta], \ \[Phi])\)\)]],
  " es  ",
  Cell[BoxData[
      \(TraditionalForm\`g(
          r, \[Theta], \[Phi]) = \((r\ cos\ \[Phi]\ sen\ \[Theta], \ 
          r\ sen\ \[Phi]\ sen\ \[Theta], r\ cos\ \[Theta])\)\)]],
  "; su variaci\[OAcute]n con respecto a ",
  StyleBox["r",
    FontSlant->"Italic"],
  " manteniendo \[Theta] y \[Phi] constantes es la derivada parcial respecto \
a ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", su variaci\[OAcute]n con respecto a \[Theta] manteniendo ",
  StyleBox["r",
    FontSlant->"Italic"],
  " y \[Phi] constantes es la derivada parcial respecto a \[Theta] y su \
variaci\[OAcute]n con respecto a \[Phi] manteniendo ",
  StyleBox["r",
    FontSlant->"Italic"],
  " y \[Theta] constantes es la derivada parcial respecto a \[Phi]. "
}], "Text"],

Cell[BoxData[{
    \(Clear[g]\), "\n", 
    \(g[r_, \[Theta]_, \[Phi]_] := {r\ Cos[\[Phi]]\ Sin[\[Theta]], 
        r\ Sin[\[Phi]]\ Sin[\[Theta]], r\ Cos[\[Theta]]}\), "\n", 
    \(u1 = D[g[r, \[Theta], \[Phi]], r]\), "\n", 
    \(u2 = D[g[r, \[Theta], \[Phi]], \[Theta]]\), "\n", 
    \(u3 = D[g[r, \[Theta], \[Phi]], \[Phi]]\)}], "Input"],

Cell["Observa que estos vectores son ortogonales", "Text"],

Cell[BoxData[
    \({u1 . u2, u1 . u3, u2 . u3} // Simplify\)], "Input"],

Cell["\<\
Para obtener una base ortonormal a partir de ellos todo lo que tenemos que \
hacer es normalizarlos. Calculemos sus normas.\
\>", "Text"],

Cell[BoxData[
    \({norma[u1], norma[u2], norma[u3]} // Simplify\)], "Input"],

Cell[TextData[{
  "Deducimos que los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], "=", 
            \((cos\ \[Phi]\ sen\ \[Theta], sen\ \[Phi]\ sen\ \[Theta], 
              cos\ \[Theta])\)}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "=", 
            \((cos\ \[Phi]\ cos\ \[Theta], sen\ \[Phi]\ cos\ \[Theta], 
              \(-sen\)\ \[Theta])\)}], ",", " ", 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], "=", 
            \((\(-sen\)\ \[Phi]\ , \ cos\ \[Phi], 0)\)}]}], 
        TraditionalForm]]],
  " forman una base ortonormal. Es a dicha base a la que se refiere un vector \
cuando se usan coordenadas esf\[EAcute]ricas. Observa que los vectores de \
esta base dependen de la posici\[OAcute]n del punto, es decir, no se trata de \
una base fija. F\[IAcute]jate en que si ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((r, \[Theta], \[Phi])\)\ \)\)]],
  "son las coordenadas esf\[EAcute]ricas de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\((x, y, z)\), "=", 
          RowBox[{"r", " ", 
            StyleBox[\(e\_r\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". En general, la expresi\[OAcute]n en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " de un vector  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", \((x, y, z)\)}], TraditionalForm]]],
  " se obtiene por el m\[EAcute]todo usual calculando sus proyecciones \
ortogonales sobre los vectores de la base:"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(v = \[LeftAngleBracket]v | e\_r\[RightAngleBracket] e\_r + 
              \[LeftAngleBracket]v | e\_\[Theta]\[RightAngleBracket] 
                e\_\[Theta] + 
              \[LeftAngleBracket]v | e\_\[Phi]\[RightAngleBracket] 
                e\_\[Phi]\),
          FontWeight->"Bold"], TraditionalForm]]],
  "\t\t"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que si escribimos ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", 
          \((r\ sen\ \[Theta]\ cos\ \[Phi]\ , \ 
            r\ sen\ \[Theta]\ sen\ \[Phi], r\ cos\ \[Theta])\)}], 
        TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[LeftAngleBracket]v | e\_r\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", "r"}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          
          StyleBox[
            \(\[LeftAngleBracket]v | e\_\[Theta]\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", 
          RowBox[{
            
            StyleBox[
              \(\[LeftAngleBracket]v | e\_\[Phi]\[RightAngleBracket]\),
              FontWeight->"Bold"], "=", "0"}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  "A continuaci\[OAcute]n se definen los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " como funciones que son de \[Theta] y \[Phi]."
}], "Text"],

Cell[BoxData[{
    \(er[\[Theta]_, \[Phi]_] = u1/norma[u1] // Simplify\), "\n", 
    \(e\[Theta][\[Theta]_, \[Phi]_] = u2/norma[u2] // Simplify\), "\n", 
    \(e\[Phi][\[Theta]_, \[Phi]_] = u3/norma[u3] // Simplify\)}], "Input"],

Cell[TextData[{
  "La siguiente gr\[AAcute]fica muestra la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`{\[Theta], \[Phi]} = {\[Pi]/4, \[Pi]/4}\)]],
  ". Para visualizarla mejor dicha base se ha desplazado al punto de \
coordenadas esf\[EAcute]ricas ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \[Pi]/4, \[Pi]/4}\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(punto = 
        CoordinatesToCartesian[{1, \[Pi]/4, \[Pi]/4}, Spherical];\)\), "\n", 
    \(\(graf = 
        Show[Graphics3D[{vector3D[punto], 
              vector3D[punto,  .5*er[\[Pi]/4, \[Pi]/4], Blue], 
              vector3D[punto,  .5*e\[Theta][\[Pi]/4, \[Pi]/4], Green], 
              vector3D[punto,  .7*e\[Phi][\[Pi]/4, \[Pi]/4], Red], 
              Text[\*"\"\<\!\(e\_r\)\>\"", 
                punto +  .55*er[\[Pi]/4, \[Pi]/4]], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", 
                punto +  .6*
                    e\[Theta][\[Pi]/4, \[Pi]/
                        4]], \n\t\t\t\tText[\*"\"\<\!\(e\_\[Phi]\)\>\"", 
                punto +  .78*e\[Phi][\[Pi]/4, \[Pi]/4]]}, Axes -> True, 
            PlotRange -> All, Ticks -> None, 
            TextStyle -> {FontFamily -> "\<Times\>", FontSize -> 14, 
                FontWeight -> "\<Bold\>"}]];\)\)}], "Input"],

Cell[BoxData[{
    \(SpinShow[graf]\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\), "\n", 
    \(Clear[graf, punto]\)}], "Input"],

Cell[TextData[{
  "Recuerda que la matriz jacobiana de una funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
            \((\(f\_1\)(x, y, z), \(f\_2\)(x, y, z), \(f\_3\)(x, y, z))\)}], 
          " "}], TraditionalForm]]],
  "es la matriz cuyas filas son los vectores gradiente de las funciones \
componentes de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " . El siguiente comando calcula la matriz jacobiana de un campo vectorial \
de tres variables."
}], "Text"],

Cell[BoxData[
    \(\(matrizjacobiana3[func_]\)[x_, y_, z_] := 
      Module[{u, v, w}, 
        Outer[D, func[u, v, w], {u, v, w}] /. {u -> x, v -> y, 
            w -> z}]\)], "Input"],

Cell[BoxData[
    \(\(matrizjacobiana3[g]\)[r, \[Theta], \[Phi]] // MatrixForm\)], "Input"],

Cell[TextData[{
  "Las columnas de la matriz jacobiana son las derivadas parciales ",
  Cell[BoxData[
      \(TraditionalForm\`\(u1 = D[g[r, \[Theta], \[Phi]], r]\ \)\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \ u2 = D[g[r, \[Theta], \[Phi]], \[Phi]]\)\)]],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm\`u3 = D[g[r, \[Theta], \[Phi]], \[Theta]]\)]],
  ". Las normas eucl\[IAcute]deas de las columnas de la matriz jacobiana se \
llaman ",
  StyleBox["factores m\[EAcute]tricos ",
    FontWeight->"Bold"],
  "o ",
  StyleBox["factores de escala",
    FontWeight->"Bold"],
  " del cambio a cordenadas esf\[EAcute]ricas y son ",
  Cell[BoxData[
      \(TraditionalForm\`{1, r, \ r\ sen\ \[Theta]}\)]],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
Expresi\[OAcute]n de la velocidad y la aceleraci\[OAcute]n en cordenadas esf\
\[EAcute]ricas\
\>", "Subsection"],

Cell[TextData[{
  "Consideremos un m\[OAcute]vil cuya trayectoria en el espacio viene dada \
por la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{\(x(t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(y(t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". Sean ",
  Cell[BoxData[
      \(TraditionalForm\`\((r(t), \ \[Theta](t), \[Phi](t))\)\)]],
  " las coordenadas esf\[EAcute]ricas de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " de forma que"
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
          \((\(r(t)\) cos\ \(\[Phi](t)\) sen\ \(\[Theta](t)\), 
              \(r(t)\) sen\ \(\[Phi](t)\) sen\ \(\[Theta](t)\), 
              \(r(t)\)\ cos\ \(\[Theta](t)\))\), "=", 
            RowBox[{\(r(t)\), 
              RowBox[{
                StyleBox[\(e\_r\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          \((cos\ \(\[Phi](t)\) sen\ \(\[Theta](t)\), 
            sen\ \(\[Phi](t)\) sen\ \(\[Theta](t)\), cos\ \(\[Theta](t)\))
            \)}], TraditionalForm]]],
  ". Es f\[AAcute]cil comprobar que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_r\%\(\ \[VerticalLine]\)\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{\(\[Theta]\ '\), \((t)\), 
              RowBox[{
                StyleBox[\(e\_\[Theta]\),
                  FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
            RowBox[{\(\[Phi]'\), \((t)\), "sen", " ", \(\[Theta](t)\), 
              RowBox[{
                StyleBox[\(e\_\[Phi]\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]],
  ". Podemos pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que lo haga."
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{
          RowBox[{"definimos", " ", "los", " ", "vectores", " ", 
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], 
            StyleBox[\((t)\),
              FontWeight->"Plain"]}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["t",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], 
            StyleBox[\((t)\),
              FontWeight->"Plain"]}]}], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["*)",
          FontWeight->"Plain"]}], "\n", 
      RowBox[{\(er[t_] = er[\[Theta][t], \[Phi][t]]\), ";", 
        "\n", \(e\[Theta][t_] = e\[Theta][\[Theta][t], \[Phi][t]]\), ";", 
        "\n", \(e\[Phi][t_] = e\[Phi][\[Theta][t], \[Phi][t]]\), ";", "\n", 
        RowBox[{\(D[er[t], t]\), "==", 
          RowBox[{
            RowBox[{\(\(\[Theta]\ '\)[t]\), 
              RowBox[{
                StyleBox["e\[Theta]",
                  FontWeight->"Bold"], "[", "t", "]"}]}], "+", 
            RowBox[{\(\(\[Phi]'\)[t]\), \(Sin[\[Theta][t]]\), 
              RowBox[{
                StyleBox["e\[Phi]",
                  FontWeight->"Bold"], "[", "t", "]"}]}]}]}]}], 
      " ", \( (*\ comprobamos\ esta\ igualdad\ *) \)}]], "Input"],

Cell["Deducimos que ", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
              RowBox[{
                RowBox[{
                  RowBox[{\(r'\), \((t)\), 
                    RowBox[{
                      StyleBox[\(e\_r\),
                        FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                  RowBox[{\(r(t)\), 
                    RowBox[{
                      StyleBox[\(e\_r\%\(\ \[VerticalLine]\)\),
                        FontWeight->"Bold"], "(", "t", ")"}]}]}], "=", 
                RowBox[{
                  RowBox[{\(r'\), \((t)\), 
                    RowBox[{
                      StyleBox[\(e\_r\),
                        FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                  \(\(r(t)\) \[Theta]\ ' \((t)\)\)}]}]}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
        RowBox[{
        \(r(t)\), \(\[Phi]'\), \((t)\), "sen", " ", \(\[Theta](t)\), " ", 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que es la expresi\[OAcute]n de la velocidad en coordenadas \
esf\[EAcute]ricas. Podemos pedirle a Mathematica que lo compruebe. Para ello \
calculamos las componentes del vector velocidad respecto de la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              StyleBox[\(e\_r\),
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], ",", 
            RowBox[{
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], ",", 
            RowBox[{
              StyleBox[\(e\_\[Phi]\),
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}]}], "}"}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(R[t_] := r[t] er[t];\)\), "\n", 
    \({\(R'\)[t] . er[t], \(R'\)[t] . e\[Theta][t], \(R'\)[t] . e\[Phi][t]} // 
      Simplify\)}], "Input"],

Cell["\<\
Derivando la expresi\[OAcute]n anterior puedes comprobar que la aceleraci\
\[OAcute]n viene dada por:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold"], "'"}], "'"}], \((t)\)}], "=", 
              RowBox[{
                RowBox[{
                \((\(r'\)' \((t)\) - \(r(t)\) \[Theta]\ ' \((t)\)\^2 - 
                      \(r(t)\) \[Phi]' \(\((t)\)\^2\) sen\^2\ \(\[Theta](t)\))
                    \), 
                  RowBox[{
                    StyleBox[\(e\_r\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                \((2  r' \((t)\) \[Theta]\ '\ \((t)\) + 
                    \(r(t)\) \(\[Theta]\ '\)\ ' \((t)\) - 
                    \(r(t)\) \[Phi]' \(\((t)\)\^2\) sen\ \(\[Theta](t)\)\ cos
                      \ \(\[Theta](t)\))\)}]}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
        RowBox[{
        \((2  r' \((t)\) \[Phi]' \((t)\)\ sen\ \(\[Theta](t)\) + 
              2 \( r(t)\) \[Phi]' \((t)\) \[Theta]\ ' \((t)\) cos\ 
                \(\[Theta](t)\) + 
              \(r(t)\) \(\[Phi]'\)' \((t)\) sen\ \(\[Theta](t)\))\), 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Volvamos a pedirle a Mathematica que lo compruebe calculando las \
componentes del vector aceleraci\[OAcute]n en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  StyleBox[\(e\_r\),
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}], ",", 
                RowBox[{
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}], ",", 
                RowBox[{
                  StyleBox[\(e\_\[Phi]\),
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], "}"}],
            "TraditionalForm"]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    \({\(\(R'\)'\)[t] . er[t], \(\(R'\)'\)[t] . 
          e\[Theta][t], \(\(R'\)'\)[t] . e\[Phi][t]} // Simplify\)], "Input"],

Cell[TextData[{
  StyleBox["Nota",
    FontWeight->"Bold"],
  ". En algunos libros de f\[IAcute]sica se usa la notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(r\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " , ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(\[Theta]\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          OverscriptBox["\[Phi]", 
            StyleBox["^",
              FontWeight->"Bold"]]}], TraditionalForm]]],
  ".  "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expresi\[OAcute]n de la divergencia en cordenadas esf\[EAcute]ricas", 
  "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
            "=", \((\(f\_1\)(x, y, z), \(f\_2\)(x, y, z), \(f\_3\)(x, y, 
                z))\)}], " "}], TraditionalForm]]],
  " un campo vectorial de tres variables. La divergencia de este campo es el \
campo escalar dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"div", 
            FormBox[
              RowBox[{
                RowBox[{
                  StyleBox["f",
                    FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
                "=", \(\(\[PartialD]f\_1\/\[PartialD]x\) \((x, y, 
                      z)\) + \(\[PartialD]f\_2\/\[PartialD]y\) \((x, y, 
                      z)\)\)}],
              "TraditionalForm"]}], 
          "+", \(\(\[PartialD]f\_3\/\[PartialD]z\) \((x, y, z)\)\)}], 
        TraditionalForm]]],
  ". Consideremos la expresi\[OAcute]n de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en coordenadas esf\[EAcute]ricas:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(r, \[Theta], \[Phi]\), ")"}], "=", 
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "(", \(r\ sen\ \[Theta]\ cos\ \[Phi]\ , 
          r\ sen\ \[Theta]\ sen\ \[Phi], r\ cos\ \[Theta]\), ")"}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y sean ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_r\)(r, \[Theta], \[Phi])\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(F\_\[Theta]\)(
        r, \[Theta], \[Phi])\)\(\ \)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Phi]\)(r, \[Theta], \[Phi])\)]],
  " las componentes de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(r, \[Theta], \[Phi]\), ")"}], 
        TraditionalForm]]],
  " respecto de la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ", esto es,  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(r, \[Theta], \[Phi]\), ")"}], "=", 
          RowBox[{
            RowBox[{\(\(F\_r\)(r, \[Theta], \[Phi])\), 
              StyleBox[\(e\_r\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\(F\_\[Theta]\)(\[Rho], \[Theta], \[Phi])\), 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\(F\_\[Phi]\)(r, \[Theta], \[Phi])\), 
              StyleBox[\(e\_\[Phi]\),
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". La expresi\[OAcute]n de la divergencia de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  " en coordenadas esf\[EAcute]ricas consiste en expresar la igualdad"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"div", " ", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["r",
                FontSlant->"Italic"], ",", "\[Theta]", ",", "\[Phi]"}], 
            ")"}]}], "=", 
        RowBox[{
          RowBox[{"div", " ", 
            StyleBox["f",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "cos", " ", "\[Phi]"}], " ", ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "sen", " ", "\[Phi]"}], ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
              ")"}]}], "=", "\n", "\t", 
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["f",
                      FontSlant->"Italic"], "1"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}]}], "+", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["f",
                      FontSlant->"Italic"], "2"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}]}], "+", "\[IndentingNewLine]", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["f",
                      FontSlant->"Italic"], "3"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["z",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Left],

Cell[TextData[{
  "en t\[EAcute]rminos de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_r\)(r, \[Theta], \[Phi]), 
      \(F\_\[Theta]\)(r, \[Theta], \[Phi]), 
      \(F\_\[Phi]\)(r, \[Theta], \[Phi])\)]],
  " y de sus derivadas parciales. El camino indirecto consistente en calcular \
derivadas parciales de ",
  Cell[BoxData[
      \(TraditionalForm\`F\_r\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Theta]\ \)\)]],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`F\_\[Phi]\)]],
  " para tratar de relacionarlas con ",
  Cell[BoxData[
      FormBox[
        RowBox[{"div", " ", 
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(r\ , \ \[Theta], \ \[Phi]\), 
            ")"}]}], TraditionalForm]]],
  " no se ve nada claro (puedes intentarlo para convencerte). Seguiremos el \
camino directo como hicimos para las coordenadas polares. Para ello \
expresaremos las componentes cartesianas del campo ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en funci\[OAcute]n de sus componentes ",
  Cell[BoxData[
      \(TraditionalForm\`F\_r\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Theta]\ \)\)]],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`F\_\[Phi]\)]],
  " en la base  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". La matriz del cambio de esta base a la base can\[OAcute]nica es la que \
tiene como columnas los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ","}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ". En este proceso debemos considerar ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", \[Theta] y \[Phi] como funciones de ",
  Cell[BoxData[
      \(TraditionalForm\`x, \ y, \ z\)]],
  ". Los c\[AAcute]lculos son largos y es una gran ventaja disponer de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para hacerlos. "
}], "Text"],

Cell[BoxData[{
    \(\(r[x_, y_, z_] = \@\(x\^2 + y\^2 + z\^2\);\)\), "\n", 
    \(\(\[Theta][x_, y_, z_] = 
        ArcCos[z\/\@\(x\^2 + y\^2 + z\^2\)];\)\), "\n", 
    \(\(\[Phi][x_, y_, z_] = ArcTan[x, y];\)\), "\n", 
    \(\(er[x_, y_, z_] = er[\[Theta][x, y, z], \[Phi][x, y, z]];\)\), "\n", 
    \(\(e\[Theta][x_, y_, z_] = 
        e\[Theta][\[Theta][x, y, z], \[Phi][x, y, z]];\)\), "\n", 
    \(\(\(e\[Phi][x_, y_, z_] = 
        e\[Phi][\[Theta][x, y, z], \[Phi][x, y, z]];\)\(\n\)
    \)\t\t\), "\n", 
    \(\(B = 
        Transpose[{er[x, y, z], e\[Theta][x, y, z], 
            e\[Phi][x, y, z]}];\)\), "\n", 
    \(\(f1[x_, y_, 
          z_] = \((B . {F\_r[r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, z]], 
                F\_\[Theta][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]], \n\t\t\tF\_\[Phi][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]]})\)[\([1]\)];\)\), "\n", 
    \(\(f2[x_, y_, 
          z_] = \((B . {F\_r[r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, z]], 
                F\_\[Theta][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]], \n\t\t\tF\_\[Phi][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]]})\)[\([2]\)];\)\), "\n", 
    \(\(f3[x_, y_, 
          z_] = \((B . {F\_r[r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, z]], 
                F\_\[Theta][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]], \n\t\t\tF\_\[Phi][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]]})\)[\([3]\)];\)\), "\n", 
    \(\((D[f1[x, y, z], x] + D[f2[x, y, z], y] + 
            D[f3[x, y, z], z] /. {x -> r*Cos[\[Phi]]*\ Sin[\[Theta]], 
            y -> r*\ Sin[\[Phi]]*\ Sin[\[Theta]], 
            z -> r*\ Cos[\[Theta]]\ })\) // Simplify\)}], "Input"],

Cell["expresi\[OAcute]n que suele escribirse en la forma", "Text"],

Cell[BoxData[
    \(\(1\/r\^2\) \[PartialD]\_r\((\ 
            r\^2*\ F\_r[r, \[Theta], \[Phi]])\) + \(1\/\(r*
              Sin[\[Theta]]\)\) \[PartialD]\_\[Theta]\ \((Sin[\[Theta]]*
              F\_\[Theta][r, \[Theta], \[Phi]])\) + \(1\/\(r*
              Sin[\[Theta]]\)\) \[PartialD]\_\[Phi] F\_\[Phi][
            r, \[Theta], \[Phi]]\)], "Input"],

Cell[BoxData[
    \(\(\(Simplify[% == %%]\)\( (*\ 
      comprobamos\ que\ ambas\ expresiones\ son\ iguales\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Podemos usar comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " definidos en el paquete \"VectorAnalysis\" para obtener directamente el \
resultado anterior aunque, claro est\[AAcute], eso no te ayudar\[AAcute] a \
comprender el significado de dicho resultado."
}], "Text"],

Cell[BoxData[
    \(Div[{F\_r[r\ , \[Theta], \[Phi]], F\_\[Theta][r\ , \[Theta], \[Phi]], 
          F\_\[Phi][r\ , \[Theta], \[Phi]]}, Spherical[r, \[Theta], \[Phi]]] // 
      Simplify\)], "Input"],

Cell["\<\
Tambi\[EAcute]n podemos calcular directamente el rotacional de un campo \
vectorial en coordenadas esf\[EAcute]ricas.\
\>", "Text"],

Cell[BoxData[
    \(Curl[{F\_r[r\ , \[Theta], \[Phi]], F\_\[Theta][r\ , \[Theta], \[Phi]], 
          F\_\[Phi][r\ , \[Theta], \[Phi]]}, Spherical[r, \[Theta], \[Phi]]] // 
      Simplify\)], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Calcula la expresi\[OAcute]n del rotacional de un campo vectorial en \
coordenadas esf\[EAcute]ricas. Debes hacer t\[UAcute] los c\[AAcute]lculos y \
no usar los comandos espec\[IAcute]ficos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que se definen en el paquete \"VectorAnalysis\"."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Gradiente y elemento diferencial de longitud en coordenadas esf\[EAcute]ricas\
\
\>", "Subsection"],

Cell[TextData[{
  "Sea ",
  StyleBox["f",
    FontSlant->"Italic"],
  " un campo escalar de tres variables. Sabemos que el gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  es el campo vectorial dado por "
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(f(x, y, z)\)\), "=", 
          RowBox[{
            RowBox[{\(\[PartialD]f\/\[PartialD]x\), \((x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".  "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La expresi\[OAcute]n del gradiente de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en esf\[EAcute]ricas viene dada por"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Del]", 
          RowBox[{"f", "(", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                "cos", " ", "\[Phi]"}], " ", ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                "sen", " ", "\[Phi]"}], ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
            ")"}]}], "=", 
        RowBox[{
          RowBox[{\(\(f\_r\)(r, \[Theta], \[Phi])\), 
            StyleBox[\(e\_r\),
              FontWeight->"Bold"]}], "+", 
          RowBox[{\(\(f\_\[Theta]\)(\[Rho], \[Theta], \[Phi])\), 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "+", 
          RowBox[{\(\(f\_\[Phi]\)(r, \[Theta], \[Phi])\), 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Rho]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Theta]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Phi]\)]],
  " son las componentes del vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]f\), 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                "cos", " ", "\[Phi]"}], " ", ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                "sen", " ", "\[Phi]"}], ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
            ")"}]}], TraditionalForm]]],
  " en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". En consecuencia se trata de hacer un simple cambio de coordenadas de la \
base can\[OAcute]nica a la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". La matriz de este cambio de base es la matriz inversa de la que tiene \
por columnas los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ", es decir, la matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{"M", "=", 
          RowBox[{"Inverse", "[", 
            RowBox[{"Transpose", "[", 
              FormBox[
                RowBox[{"{", 
                  RowBox[{
                    StyleBox[\(e\_r\),
                      FontWeight->"Bold"], ",", 
                    StyleBox[\(e\_\[Theta]\),
                      FontWeight->"Bold"], ",", 
                    StyleBox[\(e\_\[Phi]\),
                      FontWeight->"Bold"]}], "}"}],
                "TraditionalForm"], "]"}], "]"}]}], TraditionalForm]]],
  "  y, como los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " son ortonormales dos a dos, se verifca que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"Transpose", "[", 
            FormBox[
              RowBox[{"{", 
                RowBox[{
                  StyleBox[\(e\_r\),
                    FontWeight->"Bold"], ",", 
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"], ",", 
                  StyleBox[\(e\_\[Phi]\),
                    FontWeight->"Bold"]}], "}"}],
              "TraditionalForm"], "]"}], "=", 
          RowBox[{"Inverse", "[", 
            FormBox[
              RowBox[{"{", 
                RowBox[{
                  StyleBox[\(e\_r\),
                    FontWeight->"Bold"], ",", 
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"], ",", 
                  StyleBox[\(e\_\[Phi]\),
                    FontWeight->"Bold"]}], "}"}],
              "TraditionalForm"], "]"}]}], TraditionalForm]]],
  ", en consecuencia, M=",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " es la matriz cuyos vectores fila son ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ". Procura entender lo que sigue."
}], "Text"],

Cell[BoxData[{
    \(\(gradf[x_, y_, z_] = {D[f[x, y, z], x], D[f[x, y, z], y], 
          D[f[x, y, z], z]};\)\), "\n", 
    \(\(reglas = {x -> r\ \ Cos[\[Phi]] Sin[\[Theta]], 
          y -> r\ \ Sin[\[Phi]] Sin\ [\[Theta]], 
          z -> r\ Cos[\[Theta]]};\)\), "\n", 
    \(\(M = {er[\[Theta], \[Phi]], e\[Theta][\[Theta], \[Phi]], 
          e\[Phi][\[Theta], \[Phi]]};\)\), "\n", 
    \(fr[r_, \[Theta]_, \[Phi]_] = \((\((M . gradf[x, y, z])\)[\([1]\)] /. 
            reglas)\) // Simplify\), "\n", 
    \(f\[Theta][
        r_, \[Theta]_, \[Phi]_] = \((\((M . gradf[x, y, z])\)[\([2]\)] /. 
            reglas)\) // Simplify\), "\n", 
    \(f\[Phi][
        r_, \[Theta]_, \[Phi]_] = \((\((M . gradf[x, y, z])\)[\([3]\)] /. 
            reglas)\) // Simplify\)}], "Input"],

Cell["\<\
Observando estos resultados nos damos cuenta de que pueden expresarse m\
\[AAcute]s f\[AAcute]cilmente como sigue.\
\>", "Text"],

Cell[BoxData[{
    \(Simplify[
      fr[r, \[Theta], \[Phi]] == 
        D[f[r\ Cos[\[Phi]]\ Sin[\[Theta]], r\ Sin[\[Theta]]\ Sin[\[Phi]], 
            r\ Cos[\[Theta]]], r]]\), "\n", 
    \(Simplify[
      f\[Theta][r, \[Theta], \[Phi]] == \(1\/r\) 
          D[f[r\ Cos[\[Phi]]\ Sin[\[Theta]], r\ Sin[\[Theta]]\ Sin[\[Phi]], 
              r\ Cos[\[Theta]]], \[Theta]]]\), "\n", 
    \(Simplify[
      f\[Phi][r, \[Theta], \[Phi]] == \(1\/\(r\ Sin[\[Theta]]\)\) 
          D[f[r\ Cos[\[Phi]]\ Sin[\[Theta]], r\ Sin[\[Theta]]\ Sin[\[Phi]], 
              r\ Cos[\[Theta]]], \[Phi]]]\)}], "Input"],

Cell["Hemos obtenido as\[IAcute] que", "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{"\[Del]", 
            RowBox[{"f", "(", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "cos", " ", "\[Phi]"}], " ", ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "sen", " ", "\[Phi]"}], ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
              ")"}]}], "=", 
          RowBox[{
            RowBox[{\(\[PartialD]\/\[PartialD]r\), 
              RowBox[{"f", "(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}], 
              StyleBox[\(e\_r\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(1\/r\), \(\[PartialD]\/\[PartialD]\[Theta]\), 
              RowBox[{"f", "(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}], 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}], "+", 
            
            RowBox[{\(1\/\(r\ sen\ \[Theta]\)\), \(\[PartialD]\/\[PartialD]\
\[Phi]\), 
              RowBox[{"f", "(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}], 
              StyleBox[\(e\_\[Phi]\),
                FontWeight->"Bold"]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es conveniente introducir la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(h(r, \[Theta], \[Phi])\), "=", 
          RowBox[{"f", "(", 
            RowBox[{
            \(r\ sen\ \[Theta]\ cos\ \[Phi]\), " ", ",", 
              \(r\ sen\ \[Theta]\ sen\ \[Phi]\), ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
            ")"}]}], TraditionalForm]]],
  " con lo que la igualdad anterior se escribe mejor en la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{"\[Del]", 
            RowBox[{"f", "(", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "cos", " ", "\[Phi]"}], " ", ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "sen", " ", "\[Phi]"}], ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
              ")"}]}], "=", 
          RowBox[{
            
            RowBox[{\(\[PartialD]h\/\[PartialD]r\), \((r, \[Theta], \[Phi])\),
               
              StyleBox[\(e\_r\),
                FontWeight->"Bold"]}], "+", 
            
            RowBox[{\(1\/r\), \(\[PartialD]h\/\[PartialD]\[Theta]\), \((r, \
\[Theta], \[Phi])\), 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}], "+", 
            
            RowBox[{\(1\/\(r\ sen\ \[Theta]\)\), \(\[PartialD]h\/\[PartialD]\
\[Phi]\), \((r, \[Theta], \[Phi])\), 
              StyleBox[\(e\_\[Phi]\),
                FontWeight->"Bold"], "\t\t"}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En los textos de f\[IAcute]sica es frecuente que no se distinga entre la \
funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  y la funci\[OAcute]n ",
  StyleBox["h",
    FontSlant->"Italic"],
  " (pues, en definitiva, son la ",
  StyleBox["misma funci\[OAcute]n ",
    FontSlant->"Italic"],
  "expresada en ",
  StyleBox["distintas",
    FontSlant->"Italic"],
  " coordenadas) y que escriban la igualdad anterior en la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[
          RowBox[{\(\[Del]f\), "=", 
            RowBox[{
              RowBox[{\(\[PartialD]f\/\[PartialD]r\), 
                StyleBox[\(e\_r\),
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(1\/r\), \(\[PartialD]f\/\[PartialD]\[Theta]\), 
                StyleBox[\(e\_\[Theta]\),
                  FontWeight->"Bold"]}], "+", 
              
              RowBox[{\(1\/\(r\ sen\ \[Theta]\)\), \
\(\[PartialD]f\/\[PartialD]\[Phi]\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold"], "\[Phi]"], "   \t"}]}]}],
          "TraditionalForm"]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
igualdad que constituye la \"expresi\[OAcute]n del gradiente en cordenadas \
esf\[EAcute]ricas\". \
\>", "Text"],

Cell[TextData[{
  "Podemos comprobarlo con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(Grad[f[r, \[Theta], \[Phi]], 
      Spherical[r, \[Theta], \[Phi]]]\)\(\ \)\)\)], "Input"],

Cell[TextData[{
  "Observa que en la expresi\[OAcute]n anterior del gradiente aparecen los \
inversos de los factores de escala multiplicando a las derivadas parciales a \
las que est\[AAcute] asociado cada uno de ellos. Como sabes, los factores de \
escala son ",
  Cell[BoxData[
      \(TraditionalForm\`{1, r, r\ sen\ \[Theta]}\)]],
  "; el primero de ellos, 1, est\[AAcute] asociado a la primera columna de la \
matriz jacobiana del cambio de coordenadas que corresponde a la derivaci\
\[OAcute]n parcial respecto a la primera variable, r; el segundo de ellos, ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", est\[AAcute] asociado a la segunda columna de la matriz jacobiana del \
cambio de coordenadas que corresponde a la derivaci\[OAcute]n parcial \
respecto a la segunda variable, \[Theta], el tercero de ellos, ",
  Cell[BoxData[
      \(TraditionalForm\`\(r\ sen\ \[Theta], \)\)]],
  " est\[AAcute] asociado a la tercera columna de la matriz jacobiana del \
cambio de coordenadas que corresponde a la derivaci\[OAcute]n parcial \
respecto a la tercera variable, \[Phi]. "
}], "Text"],

Cell["\<\
Hemos visto antes que la velocidad en coordenadas esf\[EAcute]ricas se \
expresa por\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
              RowBox[{
                RowBox[{\(r'\), \((t)\), 
                  RowBox[{
                    StyleBox[\(e\_r\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                \(\(r(t)\) \[Theta]\ ' \((t)\)\)}]}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
        RowBox[{
        \(r(t)\), \(\[Phi]'\), \((t)\), "sen", " ", \(\[Theta](t)\), " ", 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell["\<\
Esta igualdad suele expresarse con notaci\[OAcute]n m\[AAcute]s \
cl\[AAcute]sica y tambi\[EAcute]n m\[AAcute]s confusa en la forma\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"\[DifferentialD]", 
              FormBox[
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "=", 
                  RowBox[{
                    RowBox[{\(\[DifferentialD]r\), " ", 
                      StyleBox[\(e\_r\),
                        FontWeight->"Bold"]}], "+", "r"}]}],
                "TraditionalForm"]}], \(\[DifferentialD]\[Theta]\), " ", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "+", 
          RowBox[{
          "r", " ", "sen", " ", "\[Theta]", " ", \(\[DifferentialD]\[Phi]\), 
            " ", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  "\t\t(5)"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "(no te quepa duda, esta igualdad quiere decir exactamente lo mismo que la \
anterior pero en los libros de f\[IAcute]sica acostumbran a escribirla as\
\[IAcute]). Aqu\[IAcute] vuelven a aparecer los factores de escala ",
  Cell[BoxData[
      \(TraditionalForm\`1, \ r, \ r\ sen\ \[Theta]\)]],
  " multiplicando a las correspondientes \"diferenciales\" ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\[Rho]\ , \[DifferentialD]\[Theta], 
      \ \[DifferentialD]\[Phi]\)]],
  ". La igualdad anterior es la expresi\[OAcute]n del \"elemento diferencial \
de longitud\" en coordenadas esf\[EAcute]ricas. "
}], "Text"],

Cell[TextData[{
  "Si hacemos el producto escalar ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]\[Del]f | 
          \[DifferentialD]r\[RightAngleBracket]\)]],
  " usando las igualdades anteriores obtenemos lo que sigue:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[LeftAngleBracket]\[Del]f | \[DifferentialD]r\
\[RightAngleBracket]\), "=", 
          RowBox[{
            RowBox[{"\[LeftAngleBracket]", 
              RowBox[{
                FormBox[
                  RowBox[{
                    RowBox[{\(\[PartialD]f\/\[PartialD]r\), 
                      StyleBox[\(e\_r\),
                        FontWeight->"Bold"]}], "+", 
                    RowBox[{\(1\/r\), \(\[PartialD]f\/\[PartialD]\[Theta]\), 
                      StyleBox[\(e\_\[Theta]\),
                        FontWeight->"Bold"]}], "+", 
                    
                    RowBox[{\(1\/\(r\ sen\ \[Theta]\)\), \(\[PartialD]f\/\
\[PartialD]\[Phi]\), 
                      SubscriptBox[
                        StyleBox["e",
                          FontWeight->"Bold"], "\[Phi]"]}]}],
                  "TraditionalForm"], "|", 
                FormBox[
                  RowBox[{
                    RowBox[{
                      FormBox[
                        RowBox[{
                          RowBox[{\(\[DifferentialD]r\), " ", 
                            StyleBox[\(e\_r\),
                              FontWeight->"Bold"]}], "+", "r"}],
                        "TraditionalForm"], \(\[DifferentialD]\[Theta]\), " ",
                       
                      StyleBox[\(e\_\[Theta]\),
                        FontWeight->"Bold"]}], "+", 
                    RowBox[{
                    "r", " ", "sen", " ", "\[Theta]", 
                      " ", \(\[DifferentialD]\[Phi]\), " ", 
                      StyleBox[\(e\_\[Phi]\),
                        FontWeight->"Bold"]}]}],
                  "TraditionalForm"]}], "\[RightAngleBracket]"}], 
            "=", \(\(\[PartialD]f\/\[PartialD]r\) \[DifferentialD]r + \(\
\[PartialD]f\/\[PartialD]\[Theta]\) \[DifferentialD]\(\[Theta]++\) \(\
\[PartialD]f\/\[PartialD]\[Phi]\) \[DifferentialD]\[Phi]\)}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En esta igualdad se entiende que el gradiente est\[AAcute] calculado en \
puntos del camino ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  ". Con m\[AAcute]s detalle. Si ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Rho](t), \[Theta](t), \[Phi](t))\)\)]],
  " son las coordenadas esf\[EAcute]ricas del punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  ", la igualdad anterior quiere decir lo siguiente:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[LeftAngleBracket]", 
          
          RowBox[{\(\[Del]\(f(\(r(t)\)\ cos\ \(\[Phi](t)\) 
                  sen\ \(\[Theta](t)\), \ \(r(t)\)\ sen\ \(\[Phi](t)\) 
                  sen\ \(\[Theta](t)\), \(r(t)\) cos\ \(\[Theta](t)\))\)\), 
            "|", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], \((t)\)}]}], 
          "\[RightAngleBracket]"}], "=", 
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                
                RowBox[{\(\[PartialD]h\/\[PartialD]r\), \((r(t), \ \[Theta](
                      t), \[Phi](t))\), 
                  RowBox[{
                    StyleBox[\(e\_r\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                
                RowBox[{\(1\/\(r(
                        t)\)\), \(\[PartialD]h\/\[PartialD]\[Theta]\), \((r(
                      t), \ \[Theta](t), \[Phi](t))\), 
                  RowBox[{
                    StyleBox[\(e\_\[Theta]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                
                RowBox[{\(1\/\(\(r(t)\)\ sen\ \(\[Theta](
                          t)\)\)\), \(\[PartialD]h\/\[PartialD]\[Phi]\), \((r(
                      t), \ \[Theta](t), \[Phi](t))\), 
                  SubscriptBox[
                    StyleBox["e",
                      FontWeight->"Bold"], "\[Phi]"]}]}], "|", 
              RowBox[{
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\(r'\), \((t)\), 
                        RowBox[{
                          StyleBox[\(e\_r\),
                            FontWeight->"Bold"], "(", "t", ")"}]}], 
                      "+", \(\(r(t)\) \[Theta]\ ' \((t)\)\)}],
                    "TraditionalForm"], 
                  RowBox[{
                    StyleBox[\(e\_\[Theta]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                
                RowBox[{\(r(t)\), \(\[Phi]'\), \((t)\), "sen", 
                  " ", \(\[Theta](t)\), " ", 
                  RowBox[{
                    StyleBox[\(e\_\[Phi]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
            "\[RightAngleBracket]"}], "=", "\n", 
          "\t\t", \(\(\[PartialD]h\/\[PartialD]r\) \((r(t), \ \[Theta](
                    t), \[Phi](t))\) 
                r' \((t)\) + \(\[PartialD]h\/\[PartialD]\[Theta]\) \((r(
                    t), \ \[Theta](t), \[Phi](
                    t))\) \[Theta]\ ' \((t)\) + \(\[PartialD]h\/\[PartialD]\
\[Phi]\) \((r(t), \ \[Theta](t), \[Phi](
                    t))\) \[Phi]\ ' \((t)\) = \(\[DifferentialD]\/\
\[DifferentialD]t\) \(h(r(t), \ \[Theta](t), \[Phi](t))\)\)}]}], 
      TraditionalForm]], "Text"],

Cell["Deducimos que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_a\%b\), 
          RowBox[{
            RowBox[{"\[LeftAngleBracket]", 
              RowBox[{
                RowBox[{
                  RowBox[{"\[Del]", 
                    StyleBox["f",
                      FontSlant->"Italic"]}], 
                  \((\(r \((t)\)\)\ cos\ \(\[Phi] \((t)\)\) sen\ 
                      \(\[Theta] \((t)\)\), \ 
                    \(r \((t)\)\)\ sen\ \(\[Phi] \((t)\)\) sen\ 
                      \(\[Theta] \((t)\)\), 
                    \(r \((t)\)\) cos\ \(\[Theta] \((t)\)\))\)}], "|", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold"], "'"}], \((t)\)}]}], 
              "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["h",
                FontSlant->"Italic"], 
              \((\[Rho] \((b)\), \[Theta] \((b)\), \[Phi] \((b)\))\)}], "-", 
            \(h \((\[Rho] \((a)\), \[Theta] \((a)\), \[Phi] \((a)\))\)\)}], 
          "=", "\n", "\t\t", 
          RowBox[{"=", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontSlant->"Italic"], 
                \((r \((b)\)\ cos\ \[Theta] \((b)\)\ sen\ \[Phi] \((b)\), 
                  r \((b)\)\ sen\ \[Theta] \((b)\)\ sen\ \[Phi] \((b)\), 
                  r \((b)\)\ cos\ \[Phi] \((b)\))\)}], "-", 
              RowBox[{
                StyleBox["f",
                  FontSlant->"Italic"], 
                \((r \((a)\)\ cos\ \[Theta] \((a)\)\ sen\ \[Phi] \((a)\), 
                  r \((a)\)\ sen\ \[Theta] \((a)\)\ sen\ \[Phi] \((a)\), 
                  r \((a)\)\ cos\ \[Phi] \((a)\))\)}]}]}]}]}], TextForm]], 
  "Text"],

Cell["\<\
Expresi\[OAcute]n de la integral de l\[IAcute]nea de un gradiente en \
coordenadas esf\[EAcute]ricas que es completamente an\[AAcute]loga a la \
conocida para coordenadas cartesianas. \
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Significado de los factores de escala", "Subsection"],

Cell[TextData[{
  "Consideremos la matriz jacobiana en un punto gen\[EAcute]rico ",
  Cell[BoxData[
      \(TraditionalForm\`\((r, \[Theta], \[Phi])\)\)]],
  " de la funci\[OAcute]n que introduce las coordenadas esf\[EAcute]ricas."
}], "Text"],

Cell[BoxData[
    \(S = \(matrizjacobiana3[g]\)[r, \[Theta], \[Phi]]\)], "Input"],

Cell[TextData[{
  "Esta matriz define una aplicaci\[OAcute]n lineal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " que a cada vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " hace corresponder el vector ",
  Cell[BoxData[
      \(TraditionalForm\`S . \((x, y, z)\)\)]],
  ". Calculemos la norma eucl\[IAcute]dea de la imagen de un vector en dicha \
transformaci\[OAcute]n. A veces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se empe\[NTilde]a en simplificar de forma poco apropiada y hay que \
decirle que haga lo que nosotros queremos."
}], "Text"],

Cell[BoxData[
    \(Sqrt[
      Collect[Expand[
            Simplify[\((S . {x, y, z})\) . \((S . {x, y, z})\)]], \(z\^2\) 
            r\^2] /. \((1\/2 - 1\/2\ Cos[2\ \[Theta]])\) -> 
          Sin[\[Theta]]\^2]\)], "Input"],

Cell[TextData[{
  "Deducimos que para vectores situados a lo largo del eje X, es decir, de la \
forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 0, 0)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || S . \((x, 0, 0)\)\) || \) = \( || \((x, 0, 0)\) || \)\)]],
  " y, teniendo en cuenta la linealidad, se sigue que la aplicaci\[OAcute]n ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Rule] S . \((x, y, z)\)\)]],
  " conserva distancias en el eje X. Pues bien, este es el significado de que \
el factor de escala asociado a la primera variable sea igual a 1.\nDeducimos \
tambi\[EAcute]n que para vectores situados a lo largo del eje Y, es decir, de \
la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, y, 0)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || S . \((0, y, 0)\)\) || \) = r || \((0, y, 0)\) || \)]],
  " y, teniendo en cuenta la linealidad, se sigue que la aplicaci\[OAcute]n ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Rule] S . \((x, y, z)\)\)]],
  " multiplica distancias por ",
  StyleBox["r",
    FontSlant->"Italic"],
  " en el eje Y. Pues bien, este es el significado de que el factor de escala \
asociado a la segunda variable sea igual a ",
  StyleBox["r",
    FontSlant->"Italic"],
  ".\nDeducimos tambi\[EAcute]n que para vectores situados a lo largo del eje \
Z, es decir, de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, 0, z)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || S . \((0, 0, z)\)\) || \) = 
        r\ sen\ \[Theta] || \((0, 0, z)\) || \)]],
  " y, teniendo en cuenta la linealidad, se sigue que la aplicaci\[OAcute]n ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Rule] S . \((x, y, z)\)\)]],
  " multiplica distancias por ",
  Cell[BoxData[
      \(TraditionalForm\`r\ sen\ \[Theta]\)]],
  " en el eje Z. Pues bien, este es el significado de que el factor de escala \
asociado a la tercera variable sea igual a ",
  Cell[BoxData[
      \(TraditionalForm\`r\ sen\ \(\[Theta] . \)\)]],
  "\nEn resumen, los factores de escala indican las dilataciones a lo largo \
de los ejes que hace la aplicaci\[OAcute]n lineal asociada a la matriz \
jacobiana de la aplicaci\[OAcute]n",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{\(g(r, \[Theta], \[Phi])\), "=", 
            RowBox[{"(", 
              RowBox[{
              \(r\ sen\ \[Theta]\ cos\ \[Phi]\), " ", ",", 
                \(r\ sen\ \[Theta]\ sen\ \[Phi]\), ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
              ")"}]}]}], TraditionalForm]]],
  ". Suele decirse que la aplicaci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es la que, a ",
  StyleBox["escala infinitesimal",
    FontSlant->"Italic"],
  ", produce esas dilataciones. Observa que la expresi\[OAcute]n del \
\"elemento diferencial de longitud\" en coordenadas esf\[EAcute]ricas tiene \
en cuenta dichos factores de escala. "
}], "Text"],

Cell[TextData[{
  "Al igual que cada factor de escala mide la dilataci\[OAcute]n \
infinitesimal a lo largo de un eje, el producto de los factores de escala, en \
nuestro caso ",
  Cell[BoxData[
      \(TraditionalForm\`r\^2\ sen\ \[Theta]\)]],
  ", mide el cambio en el volumen de un ortoedro a escala infinitesimal. El \
producto de los factores de escala es justamente el determinante jacobiano. \
Recuerda que la f\[OAcute]rmula del cambio de variables a coordenadas esf\
\[EAcute]ricas en una integral triple afirma que si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un campo escalar continuo en un conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^3\)]],
  " se verifica que\t\t"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[Integral]\(\[Integral]\(\[Integral]\_A\( f(x, y, z)\) \(d(
                    x, y, z)\)\)\)\), "=", 
          RowBox[{"\[Integral]", 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_B\), " ", 
                RowBox[{
                  RowBox[{"f", "(", 
                    
                    RowBox[{\(r\ sen\ \[Theta]\ cos\ \[Phi]\), " ", 
                      ",", \(r\ sen\ \[Theta]\ sen\ \[Phi]\), ",", 
                      RowBox[{
                        StyleBox["r",
                          FontSlant->"Italic"], " ", "cos", " ", 
                        "\[Theta]"}]}], ")"}], \(\(\(r\)\(\ \)\)\^2\), "sen", 
                  " ", "\[Theta]", " ", "d", \((r, \[Theta], \[Phi])\), 
                  " "}]}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"B", "=", 
            RowBox[{"{", 
              RowBox[{\((r, \[Theta], \[Phi])\), ":", 
                RowBox[{
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{
                      \(r\ sen\ \[Theta]\ cos\ \[Phi]\), " ", ",", 
                        \(r\ sen\ \[Theta]\ sen\ \[Phi]\), ",", 
                        RowBox[{
                          StyleBox["r",
                            FontSlant->"Italic"], " ", "cos", " ", 
                          "\[Theta]"}]}], ")"}],
                    "TraditionalForm"], "\[Element]", " ", "A"}]}], 
              "}"}]}]}], TraditionalForm]]],
  ". Observa que ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es la expresi\[OAcute]n del conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " en coordenadas esf\[EAcute]ricas, es decir ",
  Cell[BoxData[
      \(TraditionalForm\`A = g(B)\)]],
  ", y que en la segunda integral se multiplica por ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(r\ \)\^2\) sen\ \[Theta]\)]],
  ". Si particularizamos la igualdad anterior para la funci\[OAcute]n \
constante ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 1\)]],
  " obtenemos"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(Volumen \((g(B))\)\), "=", 
          
          FormBox[\(\[Integral]\(\[Integral]\(\[Integral]\_A 
                      1 \( d(x, 
                        y)\)\)\) = \[Integral]\(\[Integral]\(\[Integral]\_B\ \
\(\(\(r\)\(\ \)\)\^2\) sen\ \[Theta]\ \(d(r, \[Theta], \[Phi])\)\)\)\),
            "TraditionalForm"], " "}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es un ortoedro muy peque\[NTilde]o (un ortoedro ",
  StyleBox["infinitesimal",
    FontSlant->"Italic"],
  ") se verifica que "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\(\[Integral]\(\[Integral]\_B\ \(\(\(r\)\(\ \
\)\)\^2\) sen\ \[Theta]\ \(d(
                  r, \[Theta], \[Phi])\)\)\)\  \[TildeEqual] \ \ \(\(\(r\)\(\ \
\)\)\^2\) 
          sen\ \[Theta] \(\[Integral]\(\[Integral]\(\[Integral]\_B\ 
                d(\[Rho], \[Theta])\)\)\) = \ \(\(\(r\)\(\ \)\)\^2\) 
        sen\ \[Theta]\ \(Volumen(B)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  " y obtenemos ",
  Cell[BoxData[
      \(TraditionalForm\`Volumen(
          g(B))\  \[TildeEqual] \ \ \(\(\(r\)\(\ \)\)\^2\) 
          sen\ \[Theta]\ \(Volumen(B)\)\)]],
  ". ",
  "Suele decirse que ",
  Cell[BoxData[
      \(TraditionalForm\`\(r\^2\) 
        sen\ \[Theta] \[DifferentialD]r \[DifferentialD]\[Theta] \(\(\
\[DifferentialD]\)\(\[Phi]\)\(\ \)\)\)]],
  "es el \"elemento diferencial de volumen\" en coordenadas \
esf\[EAcute]ricas. "
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando que proporciona los factores de escala."
}], "Text"],

Cell[BoxData[
    \(ScaleFactors[{r, \[Theta], \[Phi]}, 
      Spherical[r, \[Theta], \[Phi]]]\)], "Input"],

Cell["\<\
Para terminar con las coordenadas esf\[EAcute]ricas ejecuta la siguiente \
celda para ver una animaci\[OAcute]n gr\[AAcute]fica en la que aparecen las \
superficies transformadas de los planos coordenados y se muestra c\[OAcute]mo \
un punto en coordenadas esf\[EAcute]ricas se sit\[UAcute]a mediante la \
intersecci\[OAcute]n de dichas superficies.\
\>", "Text"],

Cell[BoxData[
    \(\(esfericasmovie;\)\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordenadas cil\[IAcute]ndricas", "Section"],

Cell[TextData[{
  "La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`g(\[Rho], \[Theta], z) = 
        \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta], z)\)\)]],
  " es una biyecci\[OAcute]n de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"\[CapitalOmega]", "=", 
                    FormBox[\(\(\[DoubleStruckCapitalR]\^+\)\[Times]\),
                      "TraditionalForm"]}], "]"}], "-", "\[Pi]"}], ",", 
              "\[Pi]"}], "]"}], "\[Times]", "\[DoubleStruckCapitalR]"}], 
        TraditionalForm]]],
  " sobre ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\\{\((0, 0, 0)\)}\)]],
  ".  Los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Rho], \ \[Theta], \ z)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`x = \[Rho]\ cos\ \[Theta], \ 
      y = \[Rho]\ sen\ \[Theta]\)]],
  ", con ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] > 0\)]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(-\[Pi]\),
            "TraditionalForm"], "<", "\[Theta]", "\[LessEqual]", "\[Pi]"}], 
        TraditionalForm]]],
  ", se llaman las coordenadas cil\[IAcute]ndricas del punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(\(coordcilindricas;\)\)], "Input"],

Cell[BoxData[
    \(\(?\ Cylindrical\)\)], "Input"],

Cell[BoxData[
    \(Coordinates[Cylindrical]\)], "Input"],

Cell[BoxData[
    \(\(CoordinateRanges[Cylindrical]\  (*\ 
      observa\ que\ Mathematica\ usa\ para\ la\ primera\ variable\ la\ letra\ 
        r\ en\ lugar\ de\ \[Rho]\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(CoordinatesToCartesian[{\[Rho], \[Theta], \[Phi]}, Cylindrical] (*\ 
      paso\ de\ cil\[IAcute]ndricas\ a\ cartesianas\ *) \ \)\)], "Input"],

Cell[BoxData[
    \(\(CoordinatesFromCartesian[{x, y, z}, Cylindrical] (*\ 
      paso\ de\ cartesianas\ a\ cil\[IAcute]ndricas\ *) \)\)], "Input"],

Cell[TextData[{
  "Cuando se utiliza el sistema de coordenadas cil\[IAcute]ndricas los \
vectores se refieren a una base ortonormal ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], 
            StyleBox[",",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], 
              StyleBox["z",
                FontWeight->"Bold"]]}], "}"}], TraditionalForm]]],
  " que se ha representado en la figura anterior (trasladada al punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  "). En el lenguaje t\[IAcute]pico de los textos de f\[IAcute]sica se dice \
que el vector ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Rho]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Rho] manteniendo \[Theta] y z constantes, el vector  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Theta] manteniendo \[Rho] y z constantes y el vector  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_z\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta z manteniendo \[Rho] y \[Theta] constantes. En \
t\[EAcute]rminos matem\[AAcute]ticos, quiz\[AAcute]s m\[AAcute]s precisos, \
observa que el vector de posici\[OAcute]n del punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " es  ",
  Cell[BoxData[
      \(TraditionalForm
      \`g(\[Rho], \[Theta], z) = 
        \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta], z)\)\)]],
  " su variaci\[OAcute]n con respecto a \[Rho] manteniendo \[Theta] y z \
constantes es la derivada parcial respecto a \[Rho], su variaci\[OAcute]n con \
respecto a \[Theta] manteniendo \[Rho] y z constantes es la derivada parcial \
respecto a \[Theta] y su variaci\[OAcute]n con respecto a \[Phi] manteniendo \
\[Rho] y \[Theta] constantes es la derivada parcial respecto a z. "
}], "Text"],

Cell[BoxData[{
    \(Clear[g, u1, u2, u3]\), "\n", 
    \(g[\[Rho]_, \[Theta]_, 
        z_] := {\[Rho]\ Cos[\[Theta]], \[Rho]\ \ Sin[\[Theta]], z}\), "\n", 
    \(u1 = D[g[\[Rho], \[Theta], z], \[Rho]]\), "\n", 
    \(u2 = D[g[\[Rho], \[Theta], z], \[Theta]]\), "\n", 
    \(u3 = D[g[\[Rho], \[Theta], z], z]\)}], "Input"],

Cell["Observa que estos vectores son ortogonales", "Text"],

Cell[BoxData[
    \({u1 . u2, u1 . u3, u2 . u3} // Simplify\)], "Input"],

Cell["\<\
Para obtener una base ortonormal a partir de ellos todo lo que tenemos que \
hacer es normalizarlos. Calculemos sus normas.\
\>", "Text"],

Cell[BoxData[
    \({norma[u1], norma[u2], norma[u3]} // Simplify\)], "Input"],

Cell[TextData[{
  "Deducimos que los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], 
            "=", \((cos\ \[Theta], \ sen\ \[Theta], 0)\)}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], 
            "=", \((\(-sen\)\ \[Theta], cos\ \[Theta], 0)\)}], ",", " ", 
          RowBox[{
            StyleBox[\(e\_z\),
              FontWeight->"Bold"], "=", 
            RowBox[{\((0\ , 0, 1)\), "=", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " forman una base ortonormal. Es a dicha base a la que se refiere un vector \
cuando se usan coordenadas cil\[IAcute]ndricas. Observa que los vectores de \
esta base dependen de la posici\[OAcute]n del punto, es decir, no se trata de \
una base fija. F\[IAcute]jate en que si ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((\[Rho], \[Theta], z)\)\(\ \)\)\)]],
  "son las coordenadas cil\[IAcute]ndricas de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\((x, y, z)\), "=", 
          RowBox[{
            RowBox[{"\[Rho]", " ", 
              StyleBox[\(e\_\[Rho]\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{"z", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". En general, la expresi\[OAcute]n en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox["k",
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " de un vector  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", \((x, y, z)\)}], TraditionalForm]]],
  " se obtiene por el m\[EAcute]todo usual calculando sus proyecciones \
ortogonales sobre los vectores de la base:"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[\(v = \[LeftAngleBracket]v | e\_\[Rho]\[RightAngleBracket] 
                e\_\[Rho] + \[LeftAngleBracket]v | 
                    e\_\[Theta]\[RightAngleBracket] 
                e\_\[Theta] + \[LeftAngleBracket]v | k\[RightAngleBracket] 
                k\),
          FontWeight->"Bold"], TraditionalForm]]],
  "\t\t"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que si escribimos ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], 
          "=", \((\[Rho]\ cos\ \[Theta]\ , \[Rho]\ sen\ \[Theta]\ sen\ \
\[Phi], z)\)}], TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[LeftAngleBracket]v | e\_\[Rho]\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", "\[Rho]"}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            
            StyleBox[\(\[LeftAngleBracket]v | 
                  e\_\[Theta]\[RightAngleBracket]\),
              FontWeight->"Bold"], "=", "0"}], ",", " ", 
          RowBox[{
            StyleBox[\(\[LeftAngleBracket]v | k\[RightAngleBracket]\),
              FontWeight->"Bold"], "=", "z"}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell["\<\
A continuaci\[OAcute]n se definen los vectores de la base en coordenadas cil\
\[IAcute]ndricas.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[er, e\[Theta], e\[Phi]]\), "\n", 
    \(e\[Rho][\[Theta]_] = u1/norma[u1] // Simplify\), "\n", 
    \(e\[Theta][\[Theta]_] = u2/norma[u2] // Simplify\), "\n", 
    \(k = {0, 0, 1}\)}], "Input"],

Cell[TextData[{
  "La siguiente gr\[AAcute]fica muestra la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox["k",
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \[Pi]/4\)]],
  ". Para visualizarla mejor dicha base se ha trasladado al punto de \
coordenadas cil\[IAcute]ndricas ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \[Pi]/4, 1}\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(punto = 
        CoordinatesToCartesian[{1, \[Pi]/4, 1}, Cylindrical];\)\), "\n", 
    \(\(graf = 
        Show[Graphics3D[{vector3D[punto], 
              vector3D[punto,  .5*e\[Rho][\[Pi]/4], Blue], 
              vector3D[punto,  .5*e\[Theta][\[Pi]/4], Green], 
              vector3D[punto,  .5*k, Red], 
              Text[\*"\"\<\!\(e\_\[Rho]\)\>\"", 
                punto +  .6*e\[Rho][\[Pi]/4]], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", 
                punto +  .65*e\[Theta][\[Pi]/4]], \n\t\t\t\tText["\<k\>", 
                punto +  .6*k]}, Axes -> True, PlotRange -> All, 
            Ticks -> None, 
            TextStyle -> {FontFamily -> Times, FontSize -> 14, 
                FontWeight -> Bold}]];\)\)}], "Input"],

Cell[BoxData[{
    \(SpinShow[graf]\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\), "\n", 
    \(Clear[graf, punto]\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell["\<\
Completa el estudio de las coordendas cil\[IAcute]ndricas conforme al esquema \
seguido en el estudio de las coordenadas polares y esf\[EAcute]ricas. Es \
decir, debes calcular la velocidad, aceleraci\[OAcute]n, divergencia y \
gradiente en coordenadas cil\[IAcute]ndricas y hacer una \
intrepretaci\[OAcute]n de los factores de escala y de los elementos \
diferenciales de longitud y volumen.\
\>", "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordenadas curvil\[IAcute]neas ortogonales", "Section"],

Cell[TextData[{
  "Sean ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " dos subconjuntos de  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " y sea ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(g : A\)\(\[Rule]\)\(B\)\(\ \)\)\)]],
  " una biyecci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " sobre ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  ". Representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " un punto gen\[EAcute]rico de ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " y por ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((u, v, w)\)\(\ \)\)\)]],
  "un punto gen\[EAcute]rico de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ". La biyecci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " permite describir los puntos de ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " mediante puntos de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", pues dado un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] B\)]],
  " hay un \[UAcute]nico punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v, w)\) \[Element] A\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`g(u, v, w) = \((x, y, z)\)\)]],
  "; diremos que dicho punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v, w)\)\)]],
  " son las g-coordenadas del punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " y tambi\[EAcute]n diremos que la aplicaci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " introduce en ",
  StyleBox["B",
    FontSlant->"Italic"],
  " un sistema de coordenadas curvil\[IAcute]neas. Naturalmente, para que \
estas coordenadas definidas por ",
  StyleBox["g",
    FontSlant->"Italic"],
  " sean \[UAcute]tiles hay que suponer que la funci\[OAcute]n ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "tiene buenas propiedades anal\[IAcute]ticas. Suele suponerse como condici\
\[OAcute]n m\[IAcute]nima para ",
  StyleBox["g",
    FontSlant->"Italic"],
  " que sea de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  ", es decir que sus funciones componentes tengan derivadas parciales \
continuas y tambi\[EAcute]n se supone que el determinante jacobiano de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " no se anula nunca. Estas condiciones aseguran que la biyecci\[OAcute]n \
inversa de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es una funci\[OAcute]n de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  " en ",
  StyleBox["B",
    FontSlant->"Italic"],
  ". Las funciones que verifican estas propiedades (biyecciones de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  "cuya biyecci\[OAcute]n inversa tambi\[EAcute]n es de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  ") se llaman ",
  StyleBox["difeormorfismos",
    FontWeight->"Bold"],
  ". Suele exigirse tambi\[EAcute]n que la matriz jacobiana de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " calculada en cualquier punto de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " tenga la propiedad de que sus vectores columna sean dos a dos \
ortogonales. Cuando la aplicaci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " verifica estos requisitos (es un difeomorfismo de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " sonbre ",
  StyleBox["B",
    FontSlant->"Italic"],
  " cuya matriz jacobiana tiene columnas ortogonales) se dice que dicha \
aplicaci\[OAcute]n define un sistema de coordenadas curvil\[IAcute]neas \
ortogonales en ",
  StyleBox["B. ",
    FontSlant->"Italic"],
  "Las coordenadas esf\[EAcute]ricas y las cil\[IAcute]ndricas son ejemplos \
",
  "de coordenadas curvil\[IAcute]neas ortogonales (y tambi\[EAcute]n lo son \
las coordenadas polares en el plano)."
}], "Text"],

Cell["Ejemplo", "Example"],

Cell["Consideremos la aplicaci\[OAcute]n", "Text"],

Cell[BoxData[{
    \(Clear[g]\), "\n", 
    \(g[u_, v_, w_] := {u\^2 - v\^2, \ 2  u\ v, \ w\^2}\)}], "Input"],

Cell[TextData[{
  "Es evidente que dicha aplicaci\[OAcute]n no es biyectiva en todo su \
dominio natural de definici\[OAcute]n que es ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". Para obtener un conjunto en el que sea una biyecci\[OAcute]n debemos \
restringir su dominio de definici\[OAcute]n. Para ello vamos a considerar el \
conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A = {\((u, v, w)\) : \ u > 0, \ v > 0, \ w > 0}\)]],
  ". En el conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " la funci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " toma valores en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`B = {\((x, y, z)\) : y > 0, z > 0}\)]],
  ". Comprobemos que ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es una biyecci\[OAcute]n de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " sobre ",
  StyleBox["B",
    FontSlant->"Italic"],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " un punto cualquiera de ",
  StyleBox["B",
    FontSlant->"Italic"],
  " y veamos si hay un \[UAcute]nico punto de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " cuya imagen por ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es dicho punto. Deberemos seleccionar de las posibles soluciones de la \
ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g \((u, v, w)\) = \((x, y, z)\)\)]],
  " la que tenga todas sus coordenadas positivas y debe de haber una sola."
}], "Text"],

Cell[BoxData[
    \(Select[{u, v, w} /. 
            Solve[{u\^2 - v\^2, \ 2  u\ v, \ w\^2} == {x, y, z}, {u, v, w}] // 
          Simplify, todospositivos] // Flatten\)], "Input"],

Cell[TextData[{
  "Observa que, como ",
  Cell[BoxData[
      \(TraditionalForm\`y > 0, \ z > 0\)]],
  ",  la soluci\[OAcute]n obtenida efectivamente tiene todas sus coordenadas \
positivas.  Hemos probado as\[IAcute] que ",
  Cell[BoxData[
      \(TraditionalForm\`g(u, v, w) = {u\^2 - v\^2, 2\ u\ v, w\^2}\)]],
  " es una biyecci\[OAcute]n de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " sobre ",
  StyleBox["B",
    FontSlant->"Italic"],
  ". Es claro que la funci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\[Infinity]\)]],
  ". Calculemos su matriz jacobiana y el determinante jacobiano."
}], "Text"],

Cell[BoxData[{
    \(Clear[M]\), "\n", 
    \(M = \(matrizjacobiana3[g]\)[u, v, w]\), "\n", 
    \(Det[M]\)}], "Input"],

Cell[TextData[{
  "Deducimos que ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es un difeomorfismo de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " sobre ",
  StyleBox["B",
    FontSlant->"Italic"],
  ". Adem\[AAcute]s las columnas de la matriz jacobiana son ortogonales."
}], "Text"],

Cell[BoxData[
    \(\(\({u1, u2, u3} = Transpose[M]\  (*\ las\ columnas\ de\ M\ *) \n
    {u1 . u2, u1 . u3, u2 . u3}\)\(\ \)\( (*\ 
      las\ columnas\ de\ M\ son\ ortogonales\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Concluimos que la aplicaci\[OAcute]n ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "introduce un sistema de coordenadas curvil\[IAcute]neas ortogonales en ",
  StyleBox["B",
    FontSlant->"Italic"],
  ". Las g-coordenadas de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] B\)]],
  " son la \[UAcute]nica terna ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v, w)\) \[Element] A\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`g(u, v, w) = \(\((x, y, z)\) . \)\)]],
  " Definimos a continuaci\[OAcute]n funciones que pasan de unas coordenadas \
a otras."
}], "Text"],

Cell[BoxData[
    \(\(\(gcord2cart[{u_, v_, w_}] := {u\^2 - v\^2, 2\ u\ v, w\^2}\  (*\ 
      pasa\ de\ g - coordenadas\ a\ cartesianas\ *) \n
    \(\(cart2gcord[{x_, y_, 
          z_}] := {\(\@\(\(-x\) + \@\(x\^2 + y\^2\)\)\ \((x + \@\(x\^2 + y\^2\
\))\)\)\/\(\@2\ y\), \@\(\(-x\) + \@\(x\^2 + y\^2\)\)\/\@2, \@z}\)\(\n\)
    \)\)\( (*\ pasa\ de\ cartesianas\ a\ g - coordenadas\ *) \)\)\)], "Input"],

Cell["Comprobamos que son funciones inversas.", "Text"],

Cell[BoxData[{
    \(gcord2cart[cart2gcord[{x, y, z}]] // Simplify\), "\n", 
    \(cart2gcord[gcord2cart[{u, v, w}]] // Simplify\)}], "Input"],

Cell[TextData[{
  "Volvamos a la situaci\[OAcute]n general y supongamos que ",
  Cell[BoxData[
      \(TraditionalForm\`g : A \[Rule] B\)]],
  " define un sistema de coordenadas curvil\[IAcute]neas ortogonales en ",
  StyleBox["B",
    FontSlant->"Italic"],
  ". En tal caso los vectores columna de la matriz jacobiana de ",
  StyleBox["g",
    FontSlant->"Italic"],
  ", es decir las derivadas parciales de ",
  StyleBox["g",
    FontSlant->"Italic"],
  ", normalizados constituyen una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " que  notaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`{e\_1, e\_2, e\_3}\)]],
  ". Se dice que esta base est\[AAcute] asociada al sistema de coordenadas \
dado y es a esa base a la que se refieren los vectores en el sistema de \
coordenadas definido por ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". En general los vectores de la base dependen de las coordenadas, no es \
una base fija. Las normas eucl\[IAcute]deas de los vectores columna de la \
matriz jacobiana de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " se llaman factores de escala o factores m\[EAcute]tricos, los \
representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`{a, b, c}\)]],
  " (son funciones de u,v,w). "
}], "Text"],

Cell[BoxData[
    \({a, b, c} = Sqrt[{u1 . u1, u2 . u2, u3 . u3}]\)], "Input"],

Cell["Definimos los vectores de la base.", "Text"],

Cell[BoxData[{
    \(e1[{u_, v_, w_}] = u1/a\), "\n", 
    \(e2[{u_, v_, w_}] = u2/b\), "\n", 
    \(e3[{u_, v_, w_}] = u3/c\)}], "Input"],

Cell["Ahora vamos a visualizar la base antes definida.", "Text"],

Cell[BoxData[{
    \(\(punto = cart2gcord[{0, 1, 1}];\)\), "\n", 
    \(\(graf = 
        Show[Graphics3D[{vector3D[punto], 
              vector3D[punto,  .5*e1[punto], Blue], 
              vector3D[punto,  .5*e2[punto], Green], 
              vector3D[punto,  .5*e3[punto], Red], 
              Text["\<e1\>", punto +  .6*e1[punto]], 
              Text["\<e2\>", 
                punto +  .65*e2[punto]], \n\t\t\t\tText["\<e3\>", 
                punto +  .6*e3[punto]]}, Axes -> True, PlotRange -> All, 
            Ticks -> None, 
            TextStyle -> {FontFamily -> "\<Times\>", FontSize -> 14, 
                FontWeight -> "\<Bold\>"}]];\)\)}], "Input"],

Cell[BoxData[{
    \(SpinShow[graf]\), 
    \(SelectionMove[EvaluationNotebook[], All, GeneratedCell]; \n
    FrontEndTokenExecute["\<CellGroup\>"]\), 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\), 
    \(Clear[graf, punto]\)}], "Input"],

Cell[TextData[{
  "Para expresar el vector gradiente de un capo escalar ",
  StyleBox["f",
    FontSlant->"Italic"],
  " dado en coordenadas cartesianas"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[Del]\(f(x, y, z)\)\), "=", 
          RowBox[{
            RowBox[{\(\[PartialD]f\/\[PartialD]x\), \((x\_1, x\_2, x\_3)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((x\_1, x\_2, x\_3)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]z\), \((x\_1, x\_2, x\_3)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "en g-coordendas, lo que hacemos es expresar las g-componentes del vector \
gradiente en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\({e\_1\),
                  "TraditionalForm"], ",", \(e\_2\)}],
              "TraditionalForm"], ",", \(e\_3\)}], "}"}], TraditionalForm]]],
  " en funci\[OAcute]n de las componentes del vector gradiente en \
cartesianas. Para ello lo que se necesita es la matriz del cambio de base de \
cartesianas a g-coordendas. Dicha matriz es la inversa de la matriz cuyas \
columnas son los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`e\_1, \ e\_2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`e\_3\)]],
  ". Como se trata de una matriz ortogonal su inversa es su traspuesta. \
Llamemos ",
  Cell[BoxData[
      \(TraditionalForm\`\((f1, f2, f3)\)\)]],
  " a las componentes del vector ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]f\)]],
  " en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\({e\_1\),
                  "TraditionalForm"], ",", \(e\_2\)}],
              "TraditionalForm"], ",", \(e\_3\)}], "}"}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(gradf[x_, y_, z_] = {D[f[x, y, z], x], D[f[x, y, z], y], 
          D[f[x, y, z], z]};\)\), "\n", 
    \(\(reglas = {x -> u\^2 - v\^2, y -> 2\ u\ v, z -> w\^2};\)\), "\n", 
    \(\(M = {e1[{u, v, w}], e2[{u, v, w}], e3[{u, v, w}]};\)\), "\n", 
    \(f1[u_, v_, w_] = \((\((M . gradf[x, y, z])\)[\([1]\)] /. reglas)\) // 
        Simplify\), "\n", 
    \(f2[u_, v_, w_] = \((\((M . gradf[x, y, z])\)[\([2]\)] /. reglas)\) // 
        Simplify\), "\n", 
    \(f3[u_, v_, w_] = \((\((M . gradf[x, y, z])\)[\([3]\)] /. reglas)\) // 
        Simplify\)}], "Input"],

Cell["Los resultados obtenidos pueden expresarse mejor como sigue", "Text"],

Cell[BoxData[{
    \(Simplify[\(1\/a\) D[f[u\^2 - v\^2, 2\ u\ v, w\^2], u] == 
        f1[u, v, w]]\), "\n", 
    \(Simplify[\(1\/b\) D[f[u\^2 - v\^2, 2\ u\ v, w\^2], v] == 
        f2[u, v, w]]\), "\n", 
    \(Simplify[\(1\/c\) D[f[u\^2 - v\^2, 2\ u\ v, w\^2], w] == 
        f3[u, v, w]]\)}], "Input"],

Cell[BoxData[
    \(Simplify[\((gradf[x, y, z] /. reglas)\) \[Equal] 
        f1[u, v, w] e1[{u, v, w}] + f2[u, v, w] e2[{u, v, w}] + 
          f3[u, v, w] e3[{u, v, w}]]\)], "Input"],

Cell["Hemos obtenido que", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[
          RowBox[{\(\((\[Del]f)\) \((g(u, v, w))\)\), "=", 
            RowBox[{
              
              RowBox[{\(1\/a\), \(\[PartialD]\/\[PartialD]u\), \(f(
                  g(u, v, w))\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "1"]}], "+", 
              
              RowBox[{\(1\/b\), \(\[PartialD]\/\[PartialD]v\), \(f(
                  g(u, v, w))\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold"], "2"]}], "+", 
              
              RowBox[{\(1\/c\), \(\[PartialD]\/\[PartialD]w\), \(f(
                  g(u, v, w))\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold"], "3"]}]}]}],
          "TraditionalForm"]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "debes entender bien lo que significa esta igualdad: a la izquierda aparece \
la funci\[OAcute]n gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"\[Del]", 
              StyleBox["f",
                FontSlant->"Italic"]}], \((x, y, z)\)}], "=", 
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["f",
                    FontSlant->"Italic"]}], \(\[PartialD]x\)], 
              \((x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["f",
                    FontSlant->"Italic"]}], \(\[PartialD]y\)], 
              \((x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["f",
                    FontSlant->"Italic"]}], \(\[PartialD]z\)], 
              \((x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], " "}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "evaluada en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`g(u, v, w)\)]],
  ", a la derecha figuran las derivadas parciales ",
  StyleBox["de la funci\[OAcute]n compuesta ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`h(u, v, w) = f(g(u, v, w))\)]],
  "  dividida cada una de ellas por el factor de escala que corresponde a su \
variable y multiplicada por el correspondiente vector de la base asociada a \
las nuevas coordenadas (y no olvides que dichos vectores dependen de ",
  Cell[BoxData[
      \(TraditionalForm\`u, v\ , w\)]],
  "). La expresi\[OAcute]n obtenida para el gradiente es v\[AAcute]lida para \
todo sistema de coordenadas curvil\[IAcute]neas ortogonales."
}], "Text"],

Cell[TextData[{
  "Supongamos que la funci\[OAcute]n de trayectoria de un movil viene dada \
por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], 
          "=", \(g(u(t), v(t), w(t))\)}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((u(t), v(t), w(t))\)\)]],
  " son las g-coordendas del vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  ". El vector velocidad del m\[OAcute]vil lo obtenemos derivando ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", \(g(\[Gamma](t))\)}],
         TraditionalForm]]],
  " con lo que resulta que ",
  Cell[BoxData[
      \(TraditionalForm\`r\ ' \((t)\) = \(MJg(\[Gamma](
                t))\) . \[Gamma]\ ' \((t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`MJg(\[Gamma](t))\)]],
  " es la matriz jacobiana de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " calculada en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t)\)]],
  ". De esta forma obtenemos el vector velocidad en funci\[OAcute]n de las \
derivadas de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`u(t), \ v(t), \ w(t)\)]],
  ". Finalmente, expresamos el vector obtenido en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\({\(e\_1\)(t)\),
                  "TraditionalForm"], ",", \(\(e\_2\)(t)\)}],
              "TraditionalForm"], ",", \(\(e\_3\)(t)\)}], "}"}], 
        TraditionalForm]]],
  " (esta es la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\({e\_1\),
                  "TraditionalForm"], ",", \(e\_2\)}],
              "TraditionalForm"], ",", \(e\_3\)}], "}"}], TraditionalForm]]],
  " correspondiente al punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((u(t), v(t), w(t))\)\)]],
  ")."
}], "Text"],

Cell[BoxData[{
    \(Clear[r]\), "\n", 
    \(\(r[t_] = g[u[t], v[t], w[t]];\)\), "\n", 
    \(\(r'\)[t]\)}], "Input"],

Cell[BoxData[
    \(\(\(Clear[r]\n
    \({e1[t_], e2[t_], e3[t_]} = {e1[{u[t], v[t], w[t]}], 
          e2[{u[t], v[t], w[t]}], e3[{u[t], v[t], w[t]}]};\)\n
    \(r[t_] = g[u[t], v[t], w[t]];\)\n
    {r1[t_], r2[t_], 
        r3[t_]} = \(\({\(r'\)[t] . e1[t], \(r'\)[t] . e2[t], \(r'\)[t] . 
            e3[t]}\)\(//\)\(Simplify\)\( (*\ 
          las\ componentes\ del\ vector\ velocidad\ en\ la\ base\ antes\ \
definida\ *) \)\)\n
    Simplify[\(r'\)[t] == 
        r1[t] e1[t] + r2[t] e2[t] + r3[t] e3[t]]\)\(\ \)\( (*\ 
      comprobamos\ la\ expresi\[OAcute]n\ de\ \(r'\)[
          t]\ en\ la\ base\ {e1[t], e2[t], e3[t]}\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Hemos obtenido que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
          RowBox[{
            RowBox[{"a", \((t)\), " ", \(u'\), \((t)\), 
              RowBox[{
                StyleBox[\(e\_1\),
                  FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
            RowBox[{"b", \((t)\), " ", \(v'\), \((t)\), 
              RowBox[{
                StyleBox[\(e\_2\),
                  FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
            RowBox[{"c", \((t)\), " ", \(w'\), \((t)\), 
              RowBox[{
                StyleBox[\(e\_3\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`a(t), b(t), c(t)\)]],
  " son los factores de escala calculados en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((u(t), v(t), w(t))\)\)]],
  ". Esta expresi\[OAcute]n de la velocidad es v\[AAcute]lida para todo \
sistema de coordenadas curvil\[IAcute]neas ortogonales. Como la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              StyleBox[\(e\_1\),
                FontWeight->"Bold"], "(", "t", ")"}], ",", 
            RowBox[{
              StyleBox[\(e\_2\),
                FontWeight->"Bold"], "(", "t", ")"}], ",", 
            RowBox[{
              StyleBox[\(e\_3\),
                FontWeight->"Bold"], "(", "t", ")"}]}], "}"}], 
        TraditionalForm]]],
  " es ortonormal, la norma eucl\[IAcute]da del vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], " ", "'"}], \((t)\)}], TraditionalForm]]],
  " viene dada por"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"||", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], " ", "'"}], \((t)\)}], \( || \^2\)}], 
        "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], " ", "'"}], 
            RowBox[{\((t)\), " ", 
              StyleBox[".",
                FontWeight->"Bold"], " ", 
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], " ", "'"}]}], \((t)\)}], 
          "=", \(\((\(a(t)\)\ u' \((t)\))\)\^2 + \((\(b(t)\)\ v' \
\((t)\))\)\^2 + \((\(c(t)\)\ w' \((t)\))\)\^2\)}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["\<\
igualdad que en los libros de f\[IAcute]sica suelen escribir en la forma\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[\(ds\^2 = \((a\ du)\)\^2 + \((b\ dv)\)\^2 + \((c\ dw)\)\^2\),
          "TraditionalForm"]], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["\<\
y dicen que esta es la expresi\[OAcute]n del elemento diferencial de longitud \
de arco en las nuevas coordenadas. Decididamente, los autores de libros de f\
\[IAcute]sica no gustan de las derivadas y prefieren las diferenciales.\
\>", "Text"],

Cell[TextData[{
  "La divergencia de un campo vectorial ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " cuyas componentes en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_1\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_2\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_3\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " asociada a las nuevas coordenadas son los campos escalares ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1, \ F\_2, \ F\_3\)]],
  "; es decir"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(g(u, v, w)\), ")"}], "=", 
        RowBox[{
          RowBox[{\(\(F\_1\)(u, v, w)\), 
            StyleBox[\(e\_1\),
              FontWeight->"Bold"]}], "+", 
          RowBox[{\(\(F\_2\)(u, v, w)\), 
            StyleBox[\(e\_2\),
              FontWeight->"Bold"]}], "+", 
          RowBox[{\(\(F\_3\)(u, v, w)\), 
            StyleBox[\(e\_3\),
              FontWeight->"Bold"]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["se prueba que viene dada por", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[
          RowBox[{
            RowBox[{"div", " ", 
              StyleBox["F",
                FontWeight->"Bold"]}], 
            "=", \(\(1\/\(a\ b\ c\)\) \((\(\[PartialD]\/\[PartialD]\ 
                          u\) \((b\ c\ F\_1)\) + \(\[PartialD]\/\[PartialD]\ 
                          v\) \((a\ c\ F\_2)\) + \(\[PartialD]\/\[PartialD]\ 
                          w\) \((a\ b\ \ F\_3)\))\)\)}],
          "TraditionalForm"]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde se entiende que a la izquierda ",
  Cell[BoxData[
      FormBox[
        RowBox[{"div", " ", 
          StyleBox["F",
            FontWeight->"Bold"]}], TraditionalForm]]],
  " est\[AAcute] evaluada en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`g \((u, v, w)\)\)]],
  " y a la derecha las derivadas parciales est\[AAcute]n evaluadas en el \
punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v, w)\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "En las mismas condiciones se verifica la siguiente igualdad para el \
rotacional de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[
          RowBox[{"rot", " ", 
            StyleBox["F",
              FontWeight->"Bold"], " ", 
            FormBox[\(\(=\)\(1\/\(a\ b\ c\)\)\),
              "TraditionalForm"], "determinante", " ", 
            RowBox[{"(", GridBox[{
                  {
                    RowBox[{"a", " ", 
                      SubscriptBox[
                        StyleBox["e",
                          FontWeight->"Bold"], "1"]}], 
                    RowBox[{"b", " ", 
                      SubscriptBox[
                        StyleBox["e",
                          FontWeight->"Bold"], 
                        StyleBox["2",
                          FontWeight->"Bold"]]}], 
                    RowBox[{"c", " ", 
                      SubscriptBox[
                        StyleBox["e",
                          FontWeight->"Bold"], 
                        StyleBox["3",
                          FontWeight->"Bold"]]}]},
                  {\(\[PartialD]\/\[PartialD]\ 
                          u\), \(\[PartialD]\/\[PartialD]\ 
                          v\), \(\[PartialD]\/\[PartialD]\ w\)},
                  {\(a\ F\_1\), \(b\ F\_2\), \(c\ F\_3\)}
                  }], ")"}]}],
          "TraditionalForm"]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde se entiende que a la izquierda ",
  Cell[BoxData[
      FormBox[
        RowBox[{"rot", " ", 
          StyleBox["F",
            FontWeight->"Bold"]}], TraditionalForm]]],
  " est\[AAcute] evaluado en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`g \((u, v, w)\)\)]],
  " y a la derecha las derivadas parciales est\[AAcute]n evaluadas en el \
punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v, w)\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell["\<\
Completa el estudio general de las coordendas curvil\[IAcute]neas ortogonales \
conforme al esquema seguido en el estudio de las coordenadas polares y esf\
\[EAcute]ricas. Es decir, debes calcular la aceleraci\[OAcute]n y divergencia \
en coordenadas curvil\[IAcute]neas ortogonales y hacer una intrepretaci\
\[OAcute]n de los factores de escala y de los elementos diferenciales de \
longitud y volumen.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a) Representa la superficie cuya ecuaci\[OAcute]n en coordenadas esf\
\[EAcute]ricas es ",
  Cell[BoxData[
      \(TraditionalForm\`r = 1\)]],
  ".\nb) Representa una parte de la superficie cuya ecuaci\[OAcute]n en \
coordenadas esf\[EAcute]ricas es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \[Pi]/4\)]],
  ".\na) Representa una parte de la superficie ecuaci\[OAcute]n en \
coordenadas esf\[EAcute]ricas es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi] = \[Pi]/4\)]],
  ".\na) Representa una parte de la superficie cuya ecuaci\[OAcute]n en \
coordenadas cil\[IAcute]ndricas es ",
  Cell[BoxData[
      \(TraditionalForm\`r = 1\)]],
  ".\na) Representa una parte de la superficie cuya ecuaci\[OAcute]n en \
coordenadas cil\[IAcute]ndricas es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \[Pi]/4\)]],
  ".\na) Representa una parte la superficie cuya ecuaci\[OAcute]n en \
coordenadas esf\[EAcute]ricas es ",
  Cell[BoxData[
      \(TraditionalForm\`r = 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Coordenadas curvil\[IAcute]neas"], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Coordenadas curvil\[IAcute]neas"], "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[2246, 71, 85, 2, 71, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"],
    Cell[2334, 75, 86, 2, 71, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"]},
  "S5.29.1"->{
    Cell[11250, 251, 89, 2, 71, "Input",
      InitializationCell->True,
      CellTags->"S5.29.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 198816, 5676},
  {"S5.29.1", 199030, 5683}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 48, 0, 99, "Title"],
Cell[1805, 53, 188, 6, 102, "Author"],

Cell[CellGroupData[{
Cell[2018, 63, 41, 0, 93, "Section"],
Cell[2062, 65, 181, 4, 124, "Input",
  InitializationCell->True],
Cell[2246, 71, 85, 2, 71, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2334, 75, 86, 2, 71, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2423, 79, 237, 4, 98, "Input",
  InitializationCell->True],
Cell[2663, 85, 692, 14, 236, "Input",
  InitializationCell->True],
Cell[3358, 101, 949, 16, 332, "Input",
  InitializationCell->True],
Cell[4310, 119, 1468, 25, 505, "Input",
  InitializationCell->True],
Cell[5781, 146, 1946, 32, 599, "Input",
  InitializationCell->True],
Cell[7730, 180, 2149, 35, 652, "Input",
  InitializationCell->True],
Cell[9882, 217, 1191, 26, 619, "Input",
  InitializationCell->True],
Cell[11076, 245, 171, 4, 98, "Input",
  InitializationCell->True],
Cell[11250, 251, 89, 2, 71, "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"],
Cell[11342, 255, 2755, 48, 878, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[14134, 308, 38, 0, 61, "Section"],
Cell[14175, 310, 1239, 40, 67, "Text"],
Cell[15417, 352, 50, 1, 94, "Input"],
Cell[15470, 355, 1803, 45, 197, "Text"],
Cell[17276, 402, 120, 3, 41, "Text"],
Cell[17399, 407, 228, 3, 134, "Input"],
Cell[17630, 412, 1806, 53, 191, "Text"],
Cell[19439, 467, 1678, 42, 171, "Text"],
Cell[21120, 511, 114, 2, 98, "Input"],
Cell[21237, 515, 58, 0, 41, "Text"],
Cell[21298, 517, 117, 2, 72, "Input"],
Cell[21418, 521, 1872, 49, 171, "Text"],
Cell[23293, 572, 364, 11, 41, "Text"],
Cell[23660, 585, 792, 28, 42, "Text"],
Cell[24455, 615, 594, 17, 93, "Text"],
Cell[25052, 634, 152, 3, 120, "Input"],
Cell[25207, 639, 88, 1, 94, "Input"],
Cell[25298, 642, 630, 19, 67, "Text"],

Cell[CellGroupData[{
Cell[25953, 665, 112, 3, 78, "Subsection"],
Cell[26068, 670, 2483, 75, 95, "Text"],
Cell[28554, 747, 1125, 30, 40, "Text"],
Cell[29682, 779, 814, 20, 67, "Text"],
Cell[30499, 801, 870, 24, 39, "Text"],
Cell[31372, 827, 984, 31, 69, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32393, 863, 79, 0, 78, "Subsection"],
Cell[32475, 865, 949, 29, 77, "Text"],
Cell[33427, 896, 553, 14, 35, "Text"],
Cell[33983, 912, 1302, 39, 93, "Text"],
Cell[35288, 953, 2100, 57, 76, "Text"],
Cell[37391, 1012, 1119, 32, 103, "Text"],
Cell[38513, 1046, 56, 1, 41, "Text"],
Cell[38572, 1049, 170, 3, 67, "Text"],
Cell[38745, 1054, 1316, 32, 111, "Text"],
Cell[40064, 1088, 1918, 48, 110, "Text"],
Cell[41985, 1138, 127, 2, 41, "Text"],
Cell[42115, 1142, 1223, 32, 63, "Text"],
Cell[43341, 1176, 25, 0, 41, "Text"],
Cell[43369, 1178, 1541, 40, 63, "Text"],
Cell[44913, 1220, 57, 0, 41, "Text"],
Cell[44973, 1222, 849, 25, 63, "Text"],
Cell[45825, 1249, 60, 0, 41, "Text"],
Cell[45888, 1251, 825, 23, 71, "Text"],
Cell[46716, 1276, 185, 6, 42, "Text"],
Cell[46904, 1284, 54, 1, 41, "Text"],
Cell[46961, 1287, 2467, 75, 193, "Text"],
Cell[49431, 1364, 1050, 26, 63, "Text"],
Cell[50484, 1392, 889, 28, 93, "Text"],
Cell[51376, 1422, 623, 13, 212, "Input"],
Cell[52002, 1437, 1315, 36, 155, "Text"],
Cell[53320, 1475, 188, 3, 120, "Input"],
Cell[53511, 1480, 84, 1, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53632, 1486, 97, 2, 78, "Subsection"],
Cell[53732, 1490, 794, 23, 75, "Text"],
Cell[54529, 1515, 617, 17, 62, "Text"],
Cell[55149, 1534, 1235, 38, 67, "Text"],
Cell[56387, 1574, 1586, 41, 116, "Text"],
Cell[57976, 1617, 47, 0, 41, "Text"],
Cell[58026, 1619, 1330, 28, 116, "Text"],
Cell[59359, 1649, 46, 0, 41, "Text"],
Cell[59408, 1651, 737, 19, 61, "Text"],
Cell[60148, 1672, 264, 6, 41, "Text"],
Cell[60415, 1680, 696, 19, 62, "Text"],
Cell[61114, 1701, 1034, 27, 145, "Text"],
Cell[62151, 1730, 670, 17, 72, "Text"],
Cell[62824, 1749, 99, 2, 41, "Text"],
Cell[62926, 1753, 766, 13, 145, "Text"],
Cell[63695, 1768, 96, 2, 41, "Text"],
Cell[63794, 1772, 729, 22, 41, "Text"],
Cell[64526, 1796, 117, 3, 41, "Text"],
Cell[64646, 1801, 623, 18, 41, "Text"],
Cell[65272, 1821, 2028, 65, 67, "Text"],
Cell[67303, 1888, 1283, 31, 60, "Text"],
Cell[68589, 1921, 233, 6, 41, "Text"],
Cell[68825, 1929, 219, 6, 41, "Text"],
Cell[69047, 1937, 348, 7, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69432, 1949, 59, 0, 78, "Subsection"],
Cell[69494, 1951, 119, 3, 41, "Text"],
Cell[69616, 1956, 78, 1, 94, "Input"],
Cell[69697, 1959, 523, 15, 67, "Text"],
Cell[70223, 1976, 86, 1, 99, "Input"],
Cell[70312, 1979, 2780, 60, 377, "Text"],
Cell[73095, 2041, 1093, 24, 109, "Text"],
Cell[74191, 2067, 531, 14, 93, "Text"],
Cell[74725, 2083, 688, 17, 105, "Text"],
Cell[75416, 2102, 711, 17, 37, "Text"],
Cell[76130, 2121, 1004, 31, 68, "Text"],
Cell[77137, 2154, 685, 14, 119, "Text"],
Cell[77825, 2170, 344, 7, 60, "Text"],
Cell[78172, 2179, 913, 28, 93, "Text"],
Cell[79088, 2209, 408, 11, 60, "Text"],
Cell[79499, 2222, 939, 27, 94, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[80487, 2255, 48, 0, 93, "Section"],
Cell[80538, 2257, 1452, 43, 93, "Text"],
Cell[81993, 2302, 52, 1, 94, "Input"],
Cell[82048, 2305, 1138, 22, 209, "Text"],
Cell[83189, 2329, 94, 2, 41, "Text"],
Cell[83286, 2333, 60, 1, 94, "Input"],
Cell[83349, 2336, 72, 0, 41, "Text"],
Cell[83424, 2338, 49, 1, 94, "Input"],
Cell[83476, 2341, 55, 1, 94, "Input"],
Cell[83534, 2344, 60, 1, 94, "Input"],
Cell[83597, 2347, 167, 2, 120, "Input"],
Cell[83767, 2351, 151, 2, 120, "Input"],
Cell[83921, 2355, 2899, 83, 249, "Text"],
Cell[86823, 2440, 340, 6, 198, "Input"],
Cell[87166, 2448, 58, 0, 41, "Text"],
Cell[87227, 2450, 72, 1, 94, "Input"],
Cell[87302, 2453, 147, 3, 41, "Text"],
Cell[87452, 2458, 78, 1, 94, "Input"],
Cell[87533, 2461, 2060, 55, 145, "Text"],
Cell[89596, 2518, 431, 12, 41, "Text"],
Cell[90030, 2532, 1000, 34, 42, "Text"],
Cell[91033, 2568, 410, 12, 41, "Text"],
Cell[91446, 2582, 228, 3, 146, "Input"],
Cell[91677, 2587, 677, 20, 67, "Text"],
Cell[92357, 2609, 919, 17, 302, "Input"],
Cell[93279, 2628, 274, 5, 198, "Input"],
Cell[93556, 2635, 812, 24, 94, "Text"],
Cell[94371, 2661, 186, 4, 120, "Input"],
Cell[94560, 2667, 91, 1, 94, "Input"],
Cell[94654, 2670, 735, 21, 93, "Text"],

Cell[CellGroupData[{
Cell[95414, 2695, 122, 3, 78, "Subsection"],
Cell[95539, 2700, 930, 29, 67, "Text"],
Cell[96472, 2731, 592, 18, 41, "Text"],
Cell[97067, 2751, 1098, 32, 67, "Text"],
Cell[98168, 2785, 1541, 40, 224, "Input"],
Cell[99712, 2827, 30, 0, 41, "Text"],
Cell[99745, 2829, 1368, 36, 38, "Text"],
Cell[101116, 2867, 1254, 36, 67, "Text"],
Cell[102373, 2905, 164, 3, 120, "Input"],
Cell[102540, 2910, 125, 3, 41, "Text"],
Cell[102668, 2915, 1469, 36, 64, "Text"],
Cell[104140, 2953, 1358, 38, 67, "Text"],
Cell[105501, 2993, 140, 2, 72, "Input"],
Cell[105644, 2997, 875, 31, 43, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[106556, 3033, 92, 1, 78, "Subsection"],
Cell[106651, 3036, 1147, 33, 103, "Text"],
Cell[107801, 3071, 418, 11, 35, "Text"],
Cell[108222, 3084, 1753, 53, 94, "Text"],
Cell[109978, 3139, 3955, 101, 130, "Text"],
Cell[113936, 3242, 2438, 75, 172, "Text"],
Cell[116377, 3319, 1905, 38, 638, "Input"],
Cell[118285, 3359, 66, 0, 41, "Text"],
Cell[118354, 3361, 355, 6, 156, "Input"],
Cell[118712, 3369, 129, 2, 72, "Input"],
Cell[118844, 3373, 312, 7, 67, "Text"],
Cell[119159, 3382, 199, 3, 94, "Input"],
Cell[119361, 3387, 141, 3, 41, "Text"],
Cell[119505, 3392, 200, 3, 120, "Input"],

Cell[CellGroupData[{
Cell[119730, 3399, 31, 0, 68, "Exercise"],
Cell[119764, 3401, 341, 7, 67, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[120154, 3414, 109, 3, 78, "Subsection"],
Cell[120266, 3419, 230, 8, 41, "Text"],
Cell[120499, 3429, 599, 16, 49, "Text"],
Cell[121101, 3447, 154, 5, 41, "Text"],
Cell[121258, 3454, 1121, 28, 38, "Text"],
Cell[122382, 3484, 4628, 136, 171, "Text"],
Cell[127013, 3622, 782, 15, 224, "Input"],
Cell[127798, 3639, 138, 3, 41, "Text"],
Cell[127939, 3644, 597, 12, 204, "Input"],
Cell[128539, 3658, 46, 0, 41, "Text"],
Cell[128588, 3660, 3055, 74, 109, "Text"],
Cell[131646, 3736, 556, 14, 67, "Text"],
Cell[132205, 3752, 1372, 36, 62, "Text"],
Cell[133580, 3790, 471, 15, 67, "Text"],
Cell[134054, 3807, 733, 19, 72, "Text"],
Cell[134790, 3828, 122, 3, 41, "Text"],
Cell[134915, 3833, 115, 5, 41, "Text"],
Cell[135033, 3840, 114, 2, 72, "Input"],
Cell[135150, 3844, 1095, 20, 197, "Text"],
Cell[136248, 3866, 108, 3, 41, "Text"],
Cell[136359, 3871, 920, 26, 38, "Text"],
Cell[137282, 3899, 155, 3, 41, "Text"],
Cell[137440, 3904, 850, 24, 41, "Text"],
Cell[138293, 3930, 645, 12, 93, "Text"],
Cell[138941, 3944, 257, 7, 41, "Text"],
Cell[139201, 3953, 2027, 45, 62, "Text"],
Cell[141231, 4000, 640, 18, 67, "Text"],
Cell[141874, 4020, 2906, 66, 190, "Text"],
Cell[144783, 4088, 29, 0, 41, "Text"],
Cell[144815, 4090, 1815, 43, 110, "Text"],
Cell[146633, 4135, 208, 4, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[146878, 4144, 59, 0, 78, "Subsection"],
Cell[146940, 4146, 243, 5, 41, "Text"],
Cell[147186, 4153, 81, 1, 94, "Input"],
Cell[147270, 4156, 708, 19, 93, "Text"],
Cell[147981, 4177, 225, 5, 149, "Input"],
Cell[148209, 4184, 3125, 78, 415, "Text"],
Cell[151337, 4264, 745, 16, 119, "Text"],
Cell[152085, 4282, 902, 20, 60, "Text"],
Cell[152990, 4304, 1299, 37, 93, "Text"],
Cell[154292, 4343, 463, 11, 60, "Text"],
Cell[154758, 4356, 210, 8, 41, "Text"],
Cell[154971, 4366, 428, 8, 60, "Text"],
Cell[155402, 4376, 480, 14, 67, "Text"],
Cell[155885, 4392, 146, 4, 41, "Text"],
Cell[156034, 4398, 107, 2, 72, "Input"],
Cell[156144, 4402, 373, 6, 93, "Text"],
Cell[156520, 4410, 52, 1, 72, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[156621, 4417, 50, 0, 93, "Section"],
Cell[156674, 4419, 1385, 43, 67, "Text"],
Cell[158062, 4464, 54, 1, 72, "Input"],
Cell[158119, 4467, 51, 1, 72, "Input"],
Cell[158173, 4470, 57, 1, 72, "Input"],
Cell[158233, 4473, 190, 3, 124, "Input"],
Cell[158426, 4478, 164, 2, 98, "Input"],
Cell[158593, 4482, 147, 2, 98, "Input"],
Cell[158743, 4486, 2490, 63, 249, "Text"],
Cell[161236, 4551, 323, 6, 176, "Input"],
Cell[161562, 4559, 58, 0, 41, "Text"],
Cell[161623, 4561, 72, 1, 72, "Input"],
Cell[161698, 4564, 147, 3, 41, "Text"],
Cell[161848, 4569, 78, 1, 72, "Input"],
Cell[161929, 4572, 2145, 58, 145, "Text"],
Cell[164077, 4632, 422, 11, 41, "Text"],
Cell[164502, 4645, 981, 32, 42, "Text"],
Cell[165486, 4679, 119, 3, 41, "Text"],
Cell[165608, 4684, 220, 4, 150, "Input"],
Cell[165831, 4690, 647, 20, 67, "Text"],
Cell[166481, 4712, 767, 15, 254, "Input"],
Cell[167251, 4729, 274, 5, 176, "Input"],

Cell[CellGroupData[{
Cell[167550, 4738, 31, 0, 68, "Exercise"],
Cell[167584, 4740, 425, 7, 93, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[168058, 4753, 62, 0, 93, "Section"],
Cell[168123, 4755, 3877, 123, 379, "Text"],
Cell[172003, 4880, 26, 0, 51, "Example"],
Cell[172032, 4882, 50, 0, 41, "Text"],
Cell[172085, 4884, 109, 2, 120, "Input"],
Cell[172197, 4888, 1480, 45, 171, "Text"],
Cell[173680, 4935, 180, 3, 121, "Input"],
Cell[173863, 4940, 684, 21, 93, "Text"],
Cell[174550, 4963, 119, 3, 146, "Input"],
Cell[174672, 4968, 290, 11, 41, "Text"],
Cell[174965, 4981, 199, 3, 146, "Input"],
Cell[175167, 4986, 634, 18, 93, "Text"],
Cell[175804, 5006, 402, 6, 245, "Input"],
Cell[176209, 5014, 55, 0, 41, "Text"],
Cell[176267, 5016, 142, 2, 120, "Input"],
Cell[176412, 5020, 1302, 34, 171, "Text"],
Cell[177717, 5056, 78, 1, 94, "Input"],
Cell[177798, 5059, 50, 0, 41, "Text"],
Cell[177851, 5061, 138, 3, 146, "Input"],
Cell[177992, 5066, 64, 0, 41, "Text"],
Cell[178059, 5068, 667, 13, 276, "Input"],
Cell[178729, 5083, 243, 5, 176, "Input"],
Cell[178975, 5090, 165, 5, 41, "Text"],
Cell[179143, 5097, 673, 16, 62, "Text"],
Cell[179819, 5115, 1321, 39, 119, "Text"],
Cell[181143, 5156, 582, 10, 224, "Input"],
Cell[181728, 5168, 75, 0, 41, "Text"],
Cell[181806, 5170, 303, 6, 225, "Input"],
Cell[182112, 5178, 184, 3, 120, "Input"],
Cell[182299, 5183, 34, 0, 41, "Text"],
Cell[182336, 5185, 964, 26, 67, "Text"],
Cell[183303, 5213, 183, 5, 41, "Text"],
Cell[183489, 5220, 1129, 33, 62, "Text"],
Cell[184621, 5255, 736, 16, 119, "Text"],
Cell[185360, 5273, 2210, 69, 145, "Text"],
Cell[187573, 5344, 118, 3, 146, "Input"],
Cell[187694, 5349, 649, 13, 302, "Input"],
Cell[188346, 5364, 1921, 55, 93, "Text"],
Cell[190270, 5421, 776, 23, 36, "Text"],
Cell[191049, 5446, 96, 2, 41, "Text"],
Cell[191148, 5450, 219, 5, 46, "Text"],
Cell[191370, 5457, 253, 4, 67, "Text"],
Cell[191626, 5463, 631, 20, 68, "Text"],
Cell[192260, 5485, 580, 16, 35, "Text"],
Cell[192843, 5503, 44, 0, 41, "Text"],
Cell[192890, 5505, 545, 13, 68, "Text"],
Cell[193438, 5520, 462, 15, 67, "Text"],
Cell[193903, 5537, 182, 6, 42, "Text"],
Cell[194088, 5545, 1331, 33, 109, "Text"],
Cell[195422, 5580, 462, 15, 67, "Text"],

Cell[CellGroupData[{
Cell[195909, 5599, 31, 0, 68, "Exercise"],
Cell[195943, 5601, 435, 7, 93, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[196415, 5613, 31, 0, 68, "Exercise"],
Cell[196449, 5615, 1030, 26, 211, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

